/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.operations;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Project;
import java.util.List;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3Client;
import org.squashtest.tm.plugin.bugtracker.redmine3.converter.EntityConverter;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.Redmine3RestClientOperation;

public class GetProjectForCreateById
extends Redmine3RestClientOperation<Project> {
    private final int id;
    private final Redmine3Client client;
    private final EntityConverter entityConverter = new EntityConverter();

    public GetProjectForCreateById(RedmineManager manager, int id, Redmine3Client client) {
        super(manager);
        this.id = id;
        this.client = client;
    }

    @Override
    public Project doIt() throws RedmineException {
        List<Project> allProject = this.manager.getProjects();
        for (Project project : allProject) {
            if (project.getId() != this.id) continue;
            return this.entityConverter.convertToRedmineExtendedProject(project, this.client);
        }
        throw new ProjectNotFoundException();
    }
}

