/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.operations;

import com.taskadapter.redmineapi.NotFoundException;
import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Tracker;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.Redmine3RestClientOperation;

public class GetIssues
extends Redmine3RestClientOperation<List<Issue>> {
    private final List<String> issueKeys;
    private String fakeIssueSubject;
    private static final Logger logger = LoggerFactory.getLogger(GetIssues.class);

    public GetIssues(RedmineManager manager, List<String> issueKeys, String fakeIssueSubject) {
        super(manager);
        this.issueKeys = issueKeys;
        this.fakeIssueSubject = fakeIssueSubject;
    }

    @Override
    public List<Issue> doIt() throws RedmineException {
        ArrayList<Issue> issues = new ArrayList<Issue>(this.issueKeys.size());
        for (String issueKey : this.issueKeys) {
            try {
                int id = Integer.parseInt(issueKey);
                try {
                    issues.add(this.manager.getIssueById(id, new RedmineManager.INCLUDE[0]));
                }
                catch (NotFoundException notFoundException) {
                    Issue fakeIssue = new Issue();
                    Project fakeProject = new Project();
                    fakeIssue.setTracker(new Tracker());
                    fakeIssue.setId(id);
                    fakeIssue.setProject(fakeProject);
                    fakeIssue.setSubject(this.fakeIssueSubject);
                    issues.add(fakeIssue);
                }
            }
            catch (NumberFormatException nfe) {
                logger.error("The issue key : " + issueKey + " is not a number and is not coming from Redmine", (Throwable)nfe);
            }
        }
        return issues;
    }
}

