/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.client;

import java.io.IOException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpEntity;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpResponse;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.StatusLine;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.HttpResponseException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.client.ResponseHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

