/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.rest.admin.service.RestAdminPartyService;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.plugin.rest.repository.RestAdminTeamRepository;
import org.squashtest.tm.plugin.rest.repository.RestAdminUserRepository;
import org.squashtest.tm.plugin.rest.repository.RestUserRepository;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.service.user.UserManagerService;

@Service
@Transactional
public class RestAdminPartyServiceImpl
implements RestAdminPartyService {
    @Inject
    private UserManagerService userManagerService;
    @Inject
    private TeamModificationService teamModificationService;
    @Inject
    private RestAdminTeamRepository teamDao;
    @Inject
    private RestAdminUserRepository userDao;
    @Inject
    private RestUserRepository simpleUserDao;
    @Inject
    private ObjectAclService aclService;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public User findUserByLogin(String login) {
        User user = this.userManagerService.findByLogin(login);
        user.checkIsNotFromInfrastructureAdminGroup();
        return user;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<Team> findTeamsByUserLogin(String userLogin, Pageable pageable) {
        return this.teamDao.findTeamsByUserLogin(userLogin, pageable);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addMembersToTeam(String teamName, List<String> userLogins) {
        Team team = this.teamDao.findByName(teamName);
        if (team == null) {
            throw ExceptionUtils.entityNotFoundException(Team.class, (String)"name", (Object)teamName);
        }
        List<User> users = this.userDao.findByLoginIn(userLogins);
        users = users.stream().filter(user -> !user.isFromInfrastructureAdminGroup()).toList();
        team.addMembers(users);
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void removeMembersFromTeam(String teamName, List<String> userLogins) {
        Team team = this.teamDao.findByName(teamName);
        if (team == null) {
            throw ExceptionUtils.entityNotFoundException(Team.class, (String)"name", (Object)teamName);
        }
        List<User> users = this.userDao.findByLoginIn(userLogins);
        List<Long> userIds = users.stream().map(Party::getId).toList();
        this.teamModificationService.removeMembers(team.getId().longValue(), userIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addTeamsToUser(String userLogin, List<String> teamNames) {
        User user = this.findUserByLogin(userLogin);
        if (user == null) {
            throw ExceptionUtils.entityNotFoundException(User.class, (String)"login", (Object)userLogin);
        }
        List<Team> teams = this.teamDao.findByNameIn(teamNames);
        teams.forEach(team -> team.addMember(user));
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void disassociateUserFromTeams(String userLogin, List<String> teamNames) {
        User user = this.findUserByLogin(userLogin);
        if (user == null) {
            throw ExceptionUtils.entityNotFoundException(User.class, (String)"login", (Object)userLogin);
        }
        List<Team> teams = this.teamDao.findByNameIn(teamNames);
        List<Long> teamIds = teams.stream().map(Party::getId).toList();
        this.userManagerService.deassociateTeams(user.getId().longValue(), teamIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<User> findAllTeamMembers(String teamName, Pageable pageable) {
        Team team = this.teamDao.findByName(teamName);
        if (team == null) {
            throw ExceptionUtils.entityNotFoundException(Team.class, (String)"name", (Object)teamName);
        }
        return this.simpleUserDao.findMembersByTeamId(team.getId(), pageable);
    }
}

