/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.plugin.rest.admin.jackson.model.BannerMessageDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAdministrationService;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.system.SystemAdministrationService;

@Validated
@RestApiController
@UseDefaultRestApiConfiguration
public class RestBannerMessageController
extends BaseRestController {
    private final SystemAdministrationService admService;
    private final RestAdministrationService restAdministrationService;

    public RestBannerMessageController(SystemAdministrationService admService, RestAdministrationService restAdministrationService) {
        this.admService = admService;
        this.restAdministrationService = restAdministrationService;
    }

    @GetMapping(value={"/banner-message"})
    @DynamicFilterExpression
    public ResponseEntity<BannerMessageDto> getCurrentBannerMessage() {
        String bannerMessage = this.admService.findBannerMessage();
        BannerMessageDto mess = new BannerMessageDto(bannerMessage);
        return ResponseEntity.ok((Object)mess);
    }

    @PatchMapping(value={"/banner-message"})
    @DynamicFilterExpression
    public ResponseEntity<BannerMessageDto> editBannerMessage(@Valid @RequestBody BannerMessageDto bannerMessage) {
        String sanitizedMessage = this.restAdministrationService.modifyBannerMessage(bannerMessage.getMessage());
        bannerMessage.setMessage(sanitizedMessage);
        return ResponseEntity.ok((Object)bannerMessage);
    }
}

