/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.squashtest.tm.plugin.rest.core.web.TestCaseTypeFilter;

public class TestCaseTypeFilterArgumentResolver
implements HandlerMethodArgumentResolver {
    private TestCaseTypeFilter defaultFilter = TestCaseTypeFilter.ALL;
    private String testCaseTypeFilter = "type";

    public boolean supportsParameter(MethodParameter parameter) {
        return TestCaseTypeFilter.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String value = webRequest.getParameter(this.testCaseTypeFilter);
        if (value == null) {
            return this.defaultFilter;
        }
        try {
            return TestCaseTypeFilter.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String testCaseTypeFilterAll = "all";
            String testCaseTypeFilterStandard = "standard";
            String testCaseTypeFilterScripted = "scripted";
            String testCaseTypeFilterKeyword = "keyword";
            throw new IllegalArgumentException("Invalid value '" + value + "' for request parameter '" + this.testCaseTypeFilter + "'. Must be one of these values: '" + testCaseTypeFilterAll + "', '" + testCaseTypeFilterStandard + "', '" + testCaseTypeFilterScripted + "', '" + testCaseTypeFilterKeyword + "'");
        }
    }

    public TestCaseTypeFilter getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(TestCaseTypeFilter defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public String getTestCaseTypeFilter() {
        return this.testCaseTypeFilter;
    }

    public void setTestCaseTypeFilter(String testCaseTypeFilter) {
        this.testCaseTypeFilter = testCaseTypeFilter;
    }
}

