/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web;

import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMappingJacksonResponseBodyAdvice;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.SerializationDynamicFilter;
import org.squashtest.tm.plugin.rest.core.utils.URIUtils;

public class DynamicFilterResponseBodyAdvice
extends AbstractMappingJacksonResponseBodyAdvice {
    public static final String PARAM_NAME = "fields";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFilterResponseBodyAdvice.class);

    protected void beforeBodyWriteInternal(MappingJacksonValue bodyContainer, MediaType contentType, MethodParameter returnType, ServerHttpRequest request, ServerHttpResponse response) {
        String filterExpression = this.extractFilterExpression(returnType, request);
        if (filterExpression == null) {
            filterExpression = "*";
        }
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("squashrest", (SimpleBeanPropertyFilter)new SerializationDynamicFilter(filterExpression));
        bodyContainer.setFilters((FilterProvider)filterProvider);
    }

    private String extractFilterExpression(MethodParameter returnType, ServerHttpRequest request) {
        String filterExpression = this.fromUri(request);
        if (filterExpression == null) {
            filterExpression = this.fromAnnotation(returnType);
        }
        return filterExpression;
    }

    private String fromUri(ServerHttpRequest request) {
        try {
            URI uri = request.getURI();
            URL url = uri.toURL();
            Map<String, String> params = URIUtils.findQueryParameters(url);
            return params.get(PARAM_NAME);
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            LOGGER.warn("could not extract query parameters because an exception occured : ", (Throwable)ex);
            return null;
        }
    }

    private String fromAnnotation(MethodParameter returnType) {
        DynamicFilterExpression annot = (DynamicFilterExpression)returnType.getMethodAnnotation(DynamicFilterExpression.class);
        if (annot != null) {
            return annot.value();
        }
        return null;
    }
}

