/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.configuration;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="apiSecurity")
public class ApiPermissionEvaluationService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    public boolean hasPermission(Object target, String permission) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", permission, target);
    }

    public boolean hasPermission(long entityId, String entityClassName, String permission) {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(entityClassName);
            Object entity = this.entityManager.find(aClass, (Object)entityId);
            if (entity == null) {
                throw ExceptionUtils.entityNotFoundException(aClass, entityId);
            }
            return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", permission, entity);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

