/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ldap;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="authentication.ldap")
public class LdapAuthenticationProperties {
    private Server server = new Server();
    private User user = new User();

    public Server getServer() {
        return this.server;
    }

    public User getUser() {
        return this.user;
    }

    public static class Server {
        private String url = "ldap://localhost:389/dc=example,dc=com";
        private String managerDn = "";
        private String managerPassword = "";

        public String getManagerPassword() {
            return this.managerPassword;
        }

        public void setManagerPassword(String managerPassword) {
            this.managerPassword = managerPassword;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getManagerDn() {
            return this.managerDn;
        }

        public void setManagerDn(String managerDn) {
            this.managerDn = managerDn;
        }
    }

    public static class User {
        private String searchBase = "";
        private String searchFilter = "";
        private String[] dnPatterns = new String[0];
        private boolean fetchAttributes = true;

        public boolean isFetchAttributes() {
            return this.fetchAttributes;
        }

        public void setFetchAttributes(boolean fetchAttributes) {
            this.fetchAttributes = fetchAttributes;
        }

        public String[] getDnPatterns() {
            return this.dnPatterns;
        }

        public void setDnPatterns(String userDnPatterns) {
            if (userDnPatterns != null) {
                this.dnPatterns = userDnPatterns.split(";");
            }
        }

        public String getSearchFilter() {
            return this.searchFilter;
        }

        public void setSearchFilter(String searchFilter) {
            this.searchFilter = searchFilter;
        }

        public String getSearchBase() {
            return this.searchBase;
        }

        public void setSearchBase(String searchBase) {
            this.searchBase = searchBase;
        }
    }
}

