/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.Resource;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageIterationBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageRequirementBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.AbstractItemProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageTestSuiteProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QueryContext;

public class QuaCoverageIterationProcess
extends AbstractItemProcess {
    private List<QuaCoverageIterationBean> iterationBeans;

    public List<QuaCoverageIterationBean> getIterations(QueryContext ctx, Long campaignId) {
        this.iterationBeans = new ArrayList<QuaCoverageIterationBean>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("id", campaignId);
        List result = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get("iterationsByCampaign")), parameters);
        this.convertResultToIterationBean(result, ctx);
        return this.iterationBeans;
    }

    private void convertResultToIterationBean(List<Object[]> result, QueryContext ctx) {
        for (Object[] row : result) {
            QuaCoverageIterationBean iterationBean = new QuaCoverageIterationBean();
            iterationBean.setIterationId(this.evaluateExpressionToLong(row[0]));
            iterationBean.setIterationName(this.evaluateExpressionToString(row[1]));
            iterationBean.setIterationOrder(this.evaluateExpressionToLong(row[2]));
            iterationBean.setRequirements(this.getRequirementBeans(ctx, iterationBean.getIterationId()));
            QuaCoverageTestSuiteProcess testSuiteProcess = new QuaCoverageTestSuiteProcess();
            iterationBean.setTestSuites(testSuiteProcess.getTestSuites(ctx, iterationBean.getIterationId()));
            this.iterationBeans.add(iterationBean);
        }
    }

    private List<QuaCoverageRequirementBean> getRequirementBeans(QueryContext ctx, Long iterationId) {
        ArrayList<QuaCoverageRequirementBean> requirementBeans = new ArrayList<QuaCoverageRequirementBean>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("id", iterationId);
        List result = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get("requirementsByIteration")), parameters);
        for (Object[] row : result) {
            QuaCoverageRequirementBean requirementBean = new QuaCoverageRequirementBean();
            requirementBean.setRequirementId(this.evaluateExpressionToLong(row[0]));
            requirementBean.setRequirementName(this.evaluateExpressionToString(row[1]));
            requirementBean.setReference(this.evaluateExpressionToString(row[2]));
            requirementBean.setVersion(this.evaluateExpressionToString(row[3]));
            requirementBean.setCriticality(this.evaluateExpressionToString(row[4]));
            requirementBean.setSuccess(this.evaluateExpressionToLong(row[5]));
            requirementBean.setFailure(this.evaluateExpressionToLong(row[6]));
            requirementBean.setUntestable(this.evaluateExpressionToLong(row[7]));
            requirementBean.setBlocked(this.evaluateExpressionToLong(row[8]));
            requirementBean.setRunning(this.evaluateExpressionToLong(row[9]));
            requirementBean.setReady(this.evaluateExpressionToLong(row[10]));
            requirementBean.setSettled(this.evaluateExpressionToLong(row[11]));
            requirementBeans.add(requirementBean);
        }
        return requirementBeans;
    }
}

