select CLOS.DESCENDANT_ID as REQ_ID,
	   CLOS2.ANCESTOR_ID as LINKREQ_ID,
	   RV2.REFERENCE as LINKREQ_REF,
	   RES2.NAME as LINKREQ_NAME,
	   GROUP_CONCAT(case when M.LABEL is not null then concat(M.LABEL, '=Sep=') end) as MILESTONE,
	   RV2.CRITICALITY,
	   '1' as isParent,
	   MAX(CLOS2.DEPTH) as DEPTH
from  RLN_RELATIONSHIP_CLOSURE CLOS
		  left join REQUIREMENT_FOLDER RF on CLOS.DESCENDANT_ID = RF.RLN_ID
		  inner join RLN_RELATIONSHIP_CLOSURE CLOS2 on (CLOS2.DESCENDANT_ID = CLOS.DESCENDANT_ID and CLOS2.ANCESTOR_ID != CLOS.DESCENDANT_ID)
		  left join REQUIREMENT R2 on R2.RLN_ID = CLOS2.ANCESTOR_ID
		  left join REQUIREMENT_VERSION RV2 on R2.CURRENT_VERSION_ID = RV2.RES_ID
		  left join RESOURCE RES2 on RV2.RES_ID = RES2.RES_ID
		  left join MILESTONE_REQ_VERSION MRV on RV2.RES_ID = MRV.REQ_VERSION_ID
		  left join MILESTONE M on MRV.MILESTONE_ID = M.MILESTONE_ID
where CLOS.DESCENDANT_ID in (:requirementIds)
  and RV2.RES_ID IS NOT NULL
  and RF.RES_ID IS NULL
group by CLOS2.DESCENDANT_ID, RV2.RES_ID, RES2.RES_ID, CLOS.DESCENDANT_ID, CLOS2.ANCESTOR_ID
union
select CLOS.ANCESTOR_ID as REQ_ID,
	   CLOS2.DESCENDANT_ID as LINKREQ_ID,
	   RV2.REFERENCE as LINKREQ_REF,
	   RES2.NAME as LINKREQ_NAME,
	   GROUP_CONCAT(case when M.LABEL is not null then concat(M.LABEL, '=Sep=') end) as MILESTONE,
	   RV2.CRITICALITY,
	   '0' as isParent,
	   MAX(CLOS2.DEPTH) as DEPTH
from  RLN_RELATIONSHIP_CLOSURE CLOS
		  left join REQUIREMENT_FOLDER RF on CLOS.ANCESTOR_ID = RF.RLN_ID
		  inner join RLN_RELATIONSHIP_CLOSURE CLOS2 on (CLOS2.ANCESTOR_ID = CLOS.ANCESTOR_ID and CLOS2.DESCENDANT_ID != CLOS.ANCESTOR_ID)
		  left join REQUIREMENT R2 on R2.RLN_ID = CLOS2.DESCENDANT_ID
		  left join REQUIREMENT_VERSION RV2 on R2.CURRENT_VERSION_ID = RV2.RES_ID
		  left join RESOURCE RES2 on RV2.RES_ID = RES2.RES_ID
		  left join MILESTONE_REQ_VERSION MRV on RV2.RES_ID = MRV.REQ_VERSION_ID
		  left join MILESTONE M on MRV.MILESTONE_ID = M.MILESTONE_ID
where CLOS.ANCESTOR_ID in (:requirementIds)
  and RV2.RES_ID IS NOT NULL
  and RF.RES_ID IS NULL
group by CLOS2.DESCENDANT_ID, RV2.RES_ID, RES2.RES_ID, CLOS.ANCESTOR_ID, CLOS2.ANCESTOR_ID
order by REQ_ID, isParent DESC, DEPTH


