-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-cy5fdu20 (100.64.7.186)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-1.22.3.xml
-- Ran at: 02/02/2026 19:43
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.27.0
-- *********************************************************************

-- Changeset ../tm/tm.changelog-1.22.3.xml::tm-1.22.3-SQUASH-5232-add-databasechangelog-new-columns::jprioux
-- Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.3-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-1.22.3.xml', NOW(), 1, '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.27.0', '0057794952');

-- Changeset ../tm/tm.changelog-1.22.3.xml::tm-1.22.3::abo
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '1.22.3' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.3', 'abo', '../tm/tm.changelog-1.22.3.xml', NOW(), 2, '9:00d7ca4093c20ac163d30c3cf59cda23', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.27.0', '0057794952');

-- Changeset ../tm/tm.changelog-1.22.3.xml::tm-1.22.3-grant-waa-permission-on-tc-to-atw::abo
-- Grant WRITE AS AUTOMATION permission on test case to automation test writer
insert into ACL_GROUP_PERMISSION(ACL_GROUP_ID, CLASS_ID, PERMISSION_MASK) values (10, 3, 16384);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-1.22.3-grant-waa-permission-on-tc-to-atw', 'abo', '../tm/tm.changelog-1.22.3.xml', NOW(), 3, '9:ee8e70d7df4b5521adb5b68b27ab50e6', 'sql', 'Grant WRITE AS AUTOMATION permission on test case to automation test writer', 'EXECUTED', NULL, NULL, '4.27.0', '0057794952');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

