/*
 *     This file is part of the Jira Agile synchronization connector for Squash TM (sync-xsquash4jira) project.
 *     Copyright (C) 2017 Henix, henix.fr - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
/**
 * That view is a bit special : it just displays the wait pane while it executes the ajax call then immediately navigates back to the campaign
 * workspace on completion
 * 
 */
define(["jquery", "./BaseModel", "./BaseScreen", "workspace.routing", "is", "jquery.cookie"], function($, BaseModel, BaseScreen, routing, is){
	
	
	var baseUrl = squashtm.app.contextRoot + 'jirasync';

	
	// ************** conclusion *******************
	
	// this model will send the ExecplanSpecification and 
	// display messages if all went fine
	var DoneModel = BaseModel.extend({
		
		defaults : {
			selectedNode : null,
			action : "",
			iteration : null,
			selectedTestCases : null
		},
		
		toJSON : function(){
			// the raw data
			var node = this.selectedNode(),
				action = this.action(),
				iter = this.iteration(),
				tcs = this.selectedTestCases();
			
			// the refined data
			var target = { type : node.type.toUpperCase(), id : node.entityId };
			var tcIds = tcs.map(function(tc){return tc.id;});
			var iteration = iter.toJSON();
			
			return {
				action : action,
				target : target,
				testCaseIds :tcIds,
				iteration : iteration
			}
		},
		
		url : function(){
			var id = this.selectedNode().entityId;
			var url = "";
			switch(this.action()){
			case "UPDATE_CPG" :
				url = baseUrl + '/campaigns/'+id+'/test-plan'; break;
			case "UPDATE_IT" : 
				url = baseUrl + '/iterations/'+id+'/test-plan'; break;
			case "CREATE_IT" : 
				url = baseUrl + '/campaigns/'+id+'/iterations/new'; break;
			}
			return url;
		},
		
		post : function(){
			var url = this.url();
			var content = this.toJSON();
			
			return $.ajax({
				url : url,
				type : 'POST',
				dataType : 'json',
				contentType : 'application/json',
				data : JSON.stringify(content)
			});
			
		}
	});

	
	
	// ************************** done pane ***********************
	
	var DoneScreen = BaseScreen.extend({
		
		name : "done",
		
		el : "#screen-done",
		
		template : "#jirsync-plan-done-template",
		
		renderIfRequired : function(){
			// that view is special in the sense that it should 
			// be rendered only it it is actually active
			if (this.active){
				BaseScreen.prototype.renderIfRequired.apply(this, arguments);
			}
		},
		
		render : function(){
			
			var self = this;
			
			this.__renderWait();
			this.model.post().done(function(entityRef){
				self.complete(entityRef);
			});
		},
		
		
		complete : function(entityRef){

			var path = this._getCookiePath();
			var nodeId = this.toNodeId(entityRef);
			$.cookie("jstree_select", nodeId, {path : path });
			
			document.location.href = routing.buildURL("campaigns.workspace");
			
		},
		
		toNodeId : function(ref){
			var str = ref.type.toLowerCase() + '-' +ref.id;
			// uppercase the first letter
			return '#' + str.charAt(0).toUpperCase() + str.slice(1);
		},
		
        /**
	        * IE and FF add a trailing / to cookies, Chrome don't
	        * So we need to put the correct path to avoid two jstree_select cookies with different path.
	        */
        _getCookiePath : function () {
            var path = "/squash/campaign-workspace";
        	if(is.ie()||is.firefox()){
        	    path = path + "/";
        	}
        	return path;
        },
        
        isReady : function(){
        	return this._hasEverything();
        },
        
        isComplete : function(){
        	return this._hasEverything();
        },
        
        _hasEverything : function(){
        	var hasSelection = this.model.selectedTestCases().length > 0;
        	var action = this.model.action();
        	var hasIter = (action === "CREATE_IT") ? this.model.iteration().isValid() : true;
        	return hasSelection && hasIter;
        }
		
	});
	
	return {
		model : DoneModel,
		screen : DoneScreen
	}
	
	
	
});