SELECT *
FROM(
	SELECT tcs.STEP_ID AS ID,
	ats.ACTION AS ACTION,
	ats.EXPECTED_RESULT AS EXPECTED_RESULT,
	'S' AS TYPE,
	tcs.STEP_ORDER AS STEP_ORDER,
	null AS STEP_DATASET,
	(SELECT count(*) FROM ATTACHMENT attach WHERE ats.ATTACHMENT_LIST_ID  = attach.ATTACHMENT_LIST_ID)  AS attach,
	(SELECT count(*) FROM VERIFYING_STEPS  verif WHERE tcs.STEP_ID  = verif.TEST_STEP_ID)  AS verif_step,
	tcs.TEST_CASE_ID AS TEST_CASE_ID
	FROM TEST_CASE_STEPS tcs
	JOIN ACTION_TEST_STEP ats ON tcs.STEP_ID = ats.TEST_STEP_ID
	WHERE tcs.TEST_CASE_ID = :testcaseId
	UNION
	SELECT cts.CALLED_TEST_CASE_ID AS ID,
	tcln.NAME AS ACTION,
	' ' AS EXPECTED_RESULT,
	'C' AS TYPE,
	tcs.STEP_ORDER AS STEP_ORDER,
	dataset.NAME as STEP_DATASET,
	0 AS attach,
	0 AS verif_step,
	tcs.TEST_CASE_ID as TEST_CASE_ID
	FROM TEST_CASE_STEPS tcs
	JOIN CALL_TEST_STEP cts ON cts.TEST_STEP_ID = tcs.STEP_ID
	JOIN TEST_CASE_LIBRARY_NODE tcln ON tcln.TCLN_ID = cts.CALLED_TEST_CASE_ID
	LEFT JOIN DATASET dataset on cts.CALLED_DATASET = dataset.DATASET_ID
	WHERE tcs.TEST_CASE_ID = :testcaseId
	) sub
ORDER BY sub.STEP_ORDER
