/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.repository.SqlQueryRunner;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageProjectProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QueryContext;
import org.squashtest.tm.service.security.PermissionEvaluationService;

public class QuaCoverageQuery
implements ReportQuery {
    private static final String CRIT_MILESTONES = "milestones";
    private static final String CRIT_PROJ_IDS = "projectIds";
    private static final String GET_MILESTONE_LABEL = "select LABEL from MILESTONE where MILESTONE_ID = :milestoneId";
    private static final String CRIT_PROJECT_PICKER = "PROJECT_PICKER";
    private Resource requirementsByCampaign;
    private Resource requirementsByIteration;
    private Resource requirementsByTestSuite;
    private Resource projectsById;
    private Resource projectDisabledStatuses;
    private Resource allProjects;
    private Resource campaignsByProject;
    private Resource campaignsByProjectAndMilestones;
    private Resource iterationsByCampaign;
    private Resource testSuitesByIteration;
    private SqlQueryRunner runner;
    private PermissionEvaluationService permissionService;

    public void setPermissionEvaluationService(PermissionEvaluationService service) {
        this.permissionService = service;
    }

    public void setRunner(SqlQueryRunner runner) {
        this.runner = runner;
    }

    public void executeQuery(Map<String, Criteria> criteria, Map<String, Object> model) {
        QuaCoverageProcess projectProcess = new QuaCoverageProcess();
        QueryContext projectCtx = new QueryContext();
        projectCtx.put("requirementsByCampaign", this.requirementsByCampaign);
        projectCtx.put("requirementsByIteration", this.requirementsByIteration);
        projectCtx.put("requirementsByTestSuite", this.requirementsByTestSuite);
        projectCtx.put("projectsById", this.projectsById);
        projectCtx.put("projectDisabledStatuses", this.projectDisabledStatuses);
        projectCtx.put("allProjects", this.allProjects);
        projectCtx.put("campaignsByProject", this.campaignsByProject);
        projectCtx.put("campaignsByProjectAndMilestones", this.campaignsByProjectAndMilestones);
        projectCtx.put("iterationsByCampaign", this.iterationsByCampaign);
        projectCtx.put("testSuitesByIteration", this.testSuitesByIteration);
        projectCtx.setRunner(this.runner);
        String mode = (String)criteria.get("requirementsSelectionMode").getValue();
        Collection<Object> projectIds = null;
        List milestoneIds = null;
        if (mode.equals(CRIT_PROJECT_PICKER)) {
            projectIds = (List)criteria.get(CRIT_PROJ_IDS).getValue();
        } else {
            milestoneIds = (List)criteria.get(CRIT_MILESTONES).getValue();
            projectIds = new QuaCoverageProjectProcess().getProjectIds(projectCtx, milestoneIds);
        }
        Collection<String> accessibleProjectIds = this.filterAccessibleProject(projectIds);
        projectCtx.setCriteria(accessibleProjectIds);
        List<Object> result = Collections.emptyList();
        projectProcess.setMilestoneIds(milestoneIds);
        result = projectProcess.getProjects(projectCtx, accessibleProjectIds);
        if (milestoneIds != null) {
            Integer milestoneId = (Integer)milestoneIds.get(0);
            HashMap<String, Integer> args = new HashMap<String, Integer>();
            args.put("milestoneId", milestoneId);
            String milestoneLabel = (String)this.runner.executeUniqueSelect(GET_MILESTONE_LABEL, args);
            model.put("milestoneLabel", milestoneLabel);
        }
        model.put("data", result);
    }

    public void setRequirementsByCampaign(Resource requirementsByCampaign) {
        this.requirementsByCampaign = requirementsByCampaign;
    }

    public void setRequirementsByIteration(Resource requirementsByIteration) {
        this.requirementsByIteration = requirementsByIteration;
    }

    public void setRequirementsByTestSuite(Resource requirementsByTestSuite) {
        this.requirementsByTestSuite = requirementsByTestSuite;
    }

    public void setProjectsById(Resource projectsById) {
        this.projectsById = projectsById;
    }

    public void setAllProjects(Resource allProjects) {
        this.allProjects = allProjects;
    }

    public void setCampaignsByProject(Resource campaignsByProject) {
        this.campaignsByProject = campaignsByProject;
    }

    public void setCampaignsByProjectAndMilestones(Resource campaignsByProjectAndMilestones) {
        this.campaignsByProjectAndMilestones = campaignsByProjectAndMilestones;
    }

    public void setIterationsByCampaign(Resource iterationsByCampaign) {
        this.iterationsByCampaign = iterationsByCampaign;
    }

    public void setTestSuitesByIteration(Resource testSuitesByIteration) {
        this.testSuitesByIteration = testSuitesByIteration;
    }

    public void setProjectDisabledStatuses(Resource projectDisabledStatuses) {
        this.projectDisabledStatuses = projectDisabledStatuses;
    }

    private Collection<String> filterAccessibleProject(Collection<String> projectIds) {
        LinkedList<String> filtered = new LinkedList<String>();
        for (String projectId : projectIds) {
            if (!this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "READ", Long.decode(projectId), "org.squashtest.tm.domain.project.Project")) continue;
            filtered.add(projectId);
        }
        return filtered;
    }
}

