/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.WikiAttachment;
import gitlabbt.org.gitlab4j.api.models.WikiPage;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class WikisApi
extends AbstractApi {
    public WikisApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<WikiPage> getPages(Object projectIdOrPath) throws GitLabApiException {
        return this.getPages(projectIdOrPath, false, this.getDefaultPerPage()).all();
    }

    public Pager<WikiPage> getPages(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return this.getPages(projectIdOrPath, false, itemsPerPage);
    }

    public Stream<WikiPage> getPagesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getPages(projectIdOrPath, false, this.getDefaultPerPage()).stream();
    }

    public List<WikiPage> getPages(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis");
        return response.readEntity(new GenericType<List<WikiPage>>(){});
    }

    public List<WikiPage> getPages(Object projectIdOrPath, Boolean withContent) throws GitLabApiException {
        return this.getPages(projectIdOrPath, withContent, this.getDefaultPerPage()).all();
    }

    public Pager<WikiPage> getPages(Object projectIdOrPath, Boolean withContent, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm();
        if (withContent != null) {
            formData.withParam("with_content", withContent != false ? 1 : 0);
        }
        return new Pager<WikiPage>(this, WikiPage.class, itemsPerPage, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis");
    }

    public Stream<WikiPage> getPagesStream(Object projectIdOrPath, Boolean withContent) throws GitLabApiException {
        return this.getPages(projectIdOrPath, withContent, this.getDefaultPerPage()).stream();
    }

    public WikiPage getPage(Object projectIdOrPath, String slug) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", slug);
        return response.readEntity(WikiPage.class);
    }

    public Optional<WikiPage> getOptionalPage(Object projectIdOrPath, String slug) {
        try {
            return Optional.ofNullable(this.getPage(projectIdOrPath, slug));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public WikiPage createPage(Object projectIdOrPath, String title, String content) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("content", content);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis");
        return response.readEntity(WikiPage.class);
    }

    public WikiPage updatePage(Object projectIdOrPath, String slug, String title, String content) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title).withParam("slug", slug, true).withParam("content", content);
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", slug);
        return response.readEntity(WikiPage.class);
    }

    public void deletePage(Object projectIdOrPath, String slug) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", slug);
    }

    public WikiAttachment uploadAttachment(Object projectIdOrPath, File fileToUpload) throws GitLabApiException {
        return this.uploadAttachment(projectIdOrPath, fileToUpload, null);
    }

    public WikiAttachment uploadAttachment(Object projectIdOrPath, File fileToUpload, String branch) throws GitLabApiException {
        URL url;
        try {
            url = this.getApiClient().getApiUrl("projects", this.getProjectIdOrPath(projectIdOrPath), "wikis", "attachments");
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("branch", branch);
        Response response = this.upload(Response.Status.CREATED, "file", fileToUpload, null, formData, url);
        return response.readEntity(WikiAttachment.class);
    }
}

