/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.AcceptMergeRequestParams;
import gitlabbt.org.gitlab4j.api.models.ApprovalRule;
import gitlabbt.org.gitlab4j.api.models.ApprovalRuleParams;
import gitlabbt.org.gitlab4j.api.models.ApprovalState;
import gitlabbt.org.gitlab4j.api.models.Commit;
import gitlabbt.org.gitlab4j.api.models.Diff;
import gitlabbt.org.gitlab4j.api.models.Issue;
import gitlabbt.org.gitlab4j.api.models.MergeRequest;
import gitlabbt.org.gitlab4j.api.models.MergeRequestDiff;
import gitlabbt.org.gitlab4j.api.models.MergeRequestFilter;
import gitlabbt.org.gitlab4j.api.models.MergeRequestParams;
import gitlabbt.org.gitlab4j.api.models.MergeRequestVersion;
import gitlabbt.org.gitlab4j.api.models.Participant;
import gitlabbt.org.gitlab4j.api.models.Pipeline;
import gitlabbt.org.gitlab4j.models.Constants;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class MergeRequestApi
extends AbstractApi {
    public MergeRequestApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<MergeRequest> getMergeRequests(MergeRequestFilter filter) throws GitLabApiException {
        return this.getMergeRequests(filter, this.getDefaultPerPage()).all();
    }

    public List<MergeRequest> getMergeRequests(MergeRequestFilter filter, int page, int perPage) throws GitLabApiException {
        Response response;
        MultivaluedMap<String, String> queryParams;
        MultivaluedMap<String, String> multivaluedMap = queryParams = filter != null ? new GitLabApiForm(filter.getQueryParams(page, perPage)).asMap() : this.getPageQueryParams(page, perPage);
        if (filter != null && filter.getProjectId() != null && filter.getProjectId().intValue() > 0 || filter.getIids() != null && filter.getIids().size() > 0) {
            if (filter.getProjectId() == null || filter.getProjectId().intValue() == 0) {
                throw new RuntimeException("project ID cannot be null or 0");
            }
            response = this.get(Response.Status.OK, queryParams, "projects", filter.getProjectId(), "merge_requests");
        } else {
            response = this.get(Response.Status.OK, queryParams, "merge_requests");
        }
        return response.readEntity(new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(MergeRequestFilter filter, int itemsPerPage) throws GitLabApiException {
        MultivaluedMap<String, String> queryParams;
        MultivaluedMap<String, String> multivaluedMap = queryParams = filter != null ? new GitLabApiForm(filter.getQueryParams()).asMap() : null;
        if (filter != null && (filter.getProjectId() != null && filter.getProjectId().intValue() > 0 || filter.getIids() != null && filter.getIids().size() > 0)) {
            if (filter.getProjectId() == null || filter.getProjectId().intValue() == 0) {
                throw new RuntimeException("project ID cannot be null or 0");
            }
            return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, queryParams, "projects", filter.getProjectId(), "merge_requests");
        }
        if (filter != null && filter.getGroupId() != null && filter.getGroupId().intValue() > 0) {
            return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, queryParams, "groups", filter.getGroupId(), "merge_requests");
        }
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, queryParams, "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(MergeRequestFilter filter) throws GitLabApiException {
        return this.getMergeRequests(filter, this.getDefaultPerPage()).stream();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
        return response.readEntity(new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, Constants.MergeRequestState state) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, state, this.getDefaultPerPage()).all();
    }

    public List<MergeRequest> getMergeRequests(Object projectIdOrPath, Constants.MergeRequestState state, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
        return response.readEntity(new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getMergeRequests(Object projectIdOrPath, Constants.MergeRequestState state, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state);
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
    }

    public Stream<MergeRequest> getMergeRequestsStream(Object projectIdOrPath, Constants.MergeRequestState state) throws GitLabApiException {
        return this.getMergeRequests(projectIdOrPath, state, this.getDefaultPerPage()).stream();
    }

    public MergeRequest getMergeRequest(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequest(projectIdOrPath, mergeRequestIid, null, null, null);
    }

    public MergeRequest getMergeRequest(Object projectIdOrPath, Long mergeRequestIid, Boolean renderHtml, Boolean includeDivergedCommitCount, Boolean includeRebaseInProgress) throws GitLabApiException {
        GitLabApiForm queryParams = new GitLabApiForm().withParam("render_html", renderHtml).withParam("include_diverged_commits_count", includeDivergedCommitCount).withParam("include_rebase_in_progress", includeRebaseInProgress);
        Response response = this.get(Response.Status.OK, queryParams.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid);
        return response.readEntity(MergeRequest.class);
    }

    public Optional<MergeRequest> getOptionalMergeRequest(Object projectIdOrPath, Long mergeRequestIid) {
        return this.getOptionalMergeRequest(projectIdOrPath, mergeRequestIid, null, null, null);
    }

    public Optional<MergeRequest> getOptionalMergeRequest(Object projectIdOrPath, Long mergeRequestIid, Boolean renderHtml, Boolean includeDivergedCommitCount, Boolean includeRebaseInProgress) {
        try {
            return Optional.ofNullable(this.getMergeRequest(projectIdOrPath, mergeRequestIid, renderHtml, includeDivergedCommitCount, includeRebaseInProgress));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<Commit> getCommits(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public List<Commit> getCommits(Object projectIdOrPath, Long mergeRequestIid, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("owned", true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "commits");
        return response.readEntity(new GenericType<List<Commit>>(){});
    }

    public Pager<Commit> getCommits(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Commit>(this, Commit.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "commits");
    }

    public Stream<Commit> getCommitsStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getCommits(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public List<MergeRequestVersion> getDiffVersions(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getDiffVersions(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public Pager<MergeRequestVersion> getDiffVersions(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequestVersion>(this, MergeRequestVersion.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "versions");
    }

    public Stream<MergeRequestVersion> getDiffVersionsStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getDiffVersions(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public MergeRequestDiff getDiffVersion(Object projectIdOrPath, Long mergeRequestIid, Long versionId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "versions", versionId);
        return response.readEntity(MergeRequestDiff.class);
    }

    public Optional<MergeRequestDiff> getOptionalDiffVersion(Object projectIdOrPath, Long mergeRequestIid, Long versionId) {
        try {
            return Optional.ofNullable(this.getDiffVersion(projectIdOrPath, mergeRequestIid, versionId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<Diff> getDiffs(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getDiffs(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public Pager<Diff> getDiffs(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Diff>(this, Diff.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "diffs");
    }

    public Stream<Diff> getDiffsStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getDiffs(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, MergeRequestParams params) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm(params.getForm(true));
        Response response = this.post(Response.Status.CREATED, (Form)form, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests");
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, String sourceBranch, String targetBranch, String title, String description, Long assigneeId, Long targetProjectId, String[] labels, Long milestoneId, Boolean removeSourceBranch, Boolean squash) throws GitLabApiException {
        MergeRequestParams params = new MergeRequestParams().withSourceBranch(sourceBranch).withTargetBranch(targetBranch).withTitle(title).withDescription(description).withAssigneeId(assigneeId).withTargetProjectId(targetProjectId).withLabels(labels).withMilestoneId(milestoneId).withRemoveSourceBranch(removeSourceBranch).withSquash(squash);
        return this.createMergeRequest(projectIdOrPath, params);
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, String sourceBranch, String targetBranch, String title, String description, Long assigneeId, Long targetProjectId, String[] labels, Long milestoneId, Boolean removeSourceBranch) throws GitLabApiException {
        MergeRequestParams params = new MergeRequestParams().withSourceBranch(sourceBranch).withTargetBranch(targetBranch).withTitle(title).withDescription(description).withAssigneeId(assigneeId).withTargetProjectId(targetProjectId).withLabels(labels).withMilestoneId(milestoneId).withRemoveSourceBranch(removeSourceBranch);
        return this.createMergeRequest(projectIdOrPath, params);
    }

    public MergeRequest createMergeRequest(Object projectIdOrPath, String sourceBranch, String targetBranch, String title, String description, Long assigneeId) throws GitLabApiException {
        MergeRequestParams params = new MergeRequestParams().withSourceBranch(sourceBranch).withTargetBranch(targetBranch).withTitle(title).withDescription(description).withAssigneeId(assigneeId);
        return this.createMergeRequest(projectIdOrPath, params);
    }

    public MergeRequest updateMergeRequest(Object projectIdOrPath, Long mergeRequestIid, MergeRequestParams params) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm(params.getForm(false));
        Response response = this.put(Response.Status.OK, form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid);
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest updateMergeRequest(Object projectIdOrPath, Long mergeRequestIid, String targetBranch, String title, Long assigneeId, String description, Constants.StateEvent stateEvent, String labels, Long milestoneId, Boolean removeSourceBranch, Boolean squash, Boolean discussionLocked, Boolean allowCollaboration) throws GitLabApiException {
        String[] labelsArray = null;
        if (labels != null) {
            labelsArray = labels.split(",", -1);
        }
        MergeRequestParams params = new MergeRequestParams().withTargetBranch(targetBranch).withTitle(title).withAssigneeId(assigneeId).withDescription(description).withStateEvent(stateEvent).withLabels(labelsArray).withMilestoneId(milestoneId).withRemoveSourceBranch(removeSourceBranch).withDiscussionLocked(discussionLocked).withAllowCollaboration(allowCollaboration).withSquash(squash);
        return this.updateMergeRequest(projectIdOrPath, mergeRequestIid, params);
    }

    public void deleteMergeRequest(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid);
    }

    public MergeRequest acceptMergeRequest(Object projectIdOrPath, Long mergeRequestIid, AcceptMergeRequestParams params) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, new GitLabApiForm(params.getForm()).asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "merge");
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest acceptMergeRequest(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.acceptMergeRequest(projectIdOrPath, mergeRequestIid, null, null, null, null);
    }

    public MergeRequest acceptMergeRequest(Object projectIdOrPath, Long mergeRequestIid, String mergeCommitMessage, Boolean shouldRemoveSourceBranch, Boolean mergeWhenPipelineSucceeds) throws GitLabApiException {
        return this.acceptMergeRequest(projectIdOrPath, mergeRequestIid, mergeCommitMessage, shouldRemoveSourceBranch, mergeWhenPipelineSucceeds, null);
    }

    public MergeRequest acceptMergeRequest(Object projectIdOrPath, Long mergeRequestIid, String mergeCommitMessage, Boolean shouldRemoveSourceBranch, Boolean mergeWhenPipelineSucceeds, String sha) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("merge_commit_message", mergeCommitMessage).withParam("should_remove_source_branch", shouldRemoveSourceBranch).withParam(this.isApiVersion(GitLabApi.ApiVersion.V3) ? "merge_when_build_succeeds" : "merge_when_pipeline_succeeds", mergeWhenPipelineSucceeds).withParam("sha", sha);
        Response response = this.put(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "merge");
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest cancelMergeRequest(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.post(Response.Status.OK, (Form)null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "cancel_merge_when_pipeline_succeeds");
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest getMergeRequestApprovals(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getApprovals(projectIdOrPath, mergeRequestIid);
    }

    public MergeRequest getApprovals(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approvals");
        return response.readEntity(MergeRequest.class);
    }

    public ApprovalState getApprovalState(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approval_state");
        return response.readEntity(ApprovalState.class);
    }

    public List<ApprovalRule> getApprovalRules(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getApprovalRules(projectIdOrPath, mergeRequestIid, -1).all();
    }

    public Pager<ApprovalRule> getApprovalRules(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        return new Pager<ApprovalRule>(this, ApprovalRule.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approval_rules");
    }

    public Stream<ApprovalRule> getApprovalRulesStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getApprovalRules(projectIdOrPath, mergeRequestIid, -1).stream();
    }

    public ApprovalRule createApprovalRule(Object projectIdOrPath, Long mergeRequestIid, Long projectRuleId, ApprovalRuleParams params) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm(params.getForm());
        formData.withParam("approval_project_rule_id", projectRuleId);
        Response response = this.post(Response.Status.OK, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approval_rules");
        return response.readEntity(ApprovalRule.class);
    }

    public ApprovalRule updateApprovalRule(Object projectIdOrPath, Long mergeRequestIid, Long approvalRuleId, ApprovalRuleParams params) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        if (approvalRuleId == null) {
            throw new RuntimeException("approvalRuleId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm(params.getForm());
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approval_rules", approvalRuleId);
        return response.readEntity(ApprovalRule.class);
    }

    public void deleteApprovalRule(Object projectIdOrPath, Long mergeRequestIid, Long approvalRuleId) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        if (approvalRuleId == null) {
            throw new RuntimeException("approvalRuleId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approval_rules", approvalRuleId);
    }

    public MergeRequest approveMergeRequest(Object projectIdOrPath, Long mergeRequestIid, String sha) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("sha", sha);
        Response response = this.post(Response.Status.OK, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "approve");
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest unapproveMergeRequest(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        if (mergeRequestIid == null) {
            throw new RuntimeException("mergeRequestIid cannot be null");
        }
        Response response = this.post(Response.Status.OK, (Form)null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "unapprove");
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest getMergeRequestChanges(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "changes");
        return response.readEntity(MergeRequest.class);
    }

    public List<Participant> getParticipants(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getParticipants(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public List<Participant> getParticipants(Object projectIdOrPath, Long mergeRequestIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "participants");
        return response.readEntity(new GenericType<List<Participant>>(){});
    }

    public Pager<Participant> getParticipants(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Participant>(this, Participant.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "participants");
    }

    public Stream<Participant> getParticipantsStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getParticipants(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getClosesIssues(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getClosesIssues(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public List<Issue> getClosesIssues(Object projectIdOrPath, Long mergeRequestIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "closes_issues");
        return response.readEntity(new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getClosesIssues(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "closes_issues");
    }

    public Stream<Issue> getClosesIssuesStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getClosesIssues(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public List<Issue> getApprovalStatus(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getClosesIssues(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public MergeRequest rebaseMergeRequest(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        Response response = this.put(Response.Status.ACCEPTED, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "rebase");
        return response.readEntity(MergeRequest.class);
    }

    public MergeRequest getRebaseStatus(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequest(projectIdOrPath, mergeRequestIid, null, null, true);
    }

    public List<Pipeline> getMergeRequestPipelines(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestPipelines(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).all();
    }

    public Pager<Pipeline> getMergeRequestPipelines(Object projectIdOrPath, Long mergeRequestIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Pipeline>(this, Pipeline.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "pipelines");
    }

    public Stream<Pipeline> getMergeRequestPipelinesStream(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        return this.getMergeRequestPipelines(projectIdOrPath, mergeRequestIid, this.getDefaultPerPage()).stream();
    }

    public Pipeline createMergeRequestPipeline(Object projectIdOrPath, Long mergeRequestIid) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, "projects", this.getProjectIdOrPath(projectIdOrPath), "merge_requests", mergeRequestIid, "pipelines");
        return response.readEntity(Pipeline.class);
    }
}

