/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.DeployKey;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class DeployKeysApi
extends AbstractApi {
    public DeployKeysApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<DeployKey> getDeployKeys() throws GitLabApiException {
        return this.getDeployKeys(this.getDefaultPerPage()).all();
    }

    public List<DeployKey> getDeployKeys(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "deploy_keys");
        return response.readEntity(new GenericType<List<DeployKey>>(){});
    }

    public Pager<DeployKey> getDeployKeys(int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployKey>(this, DeployKey.class, itemsPerPage, null, "deploy_keys");
    }

    public Stream<DeployKey> getDeployKeysStream() throws GitLabApiException {
        return this.getDeployKeys(this.getDefaultPerPage()).stream();
    }

    public List<DeployKey> getProjectDeployKeys(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployKeys(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<DeployKey> getProjectDeployKeys(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys");
        return response.readEntity(new GenericType<List<DeployKey>>(){});
    }

    public Pager<DeployKey> getProjectDeployKeys(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<DeployKey>(this, DeployKey.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys");
    }

    public Stream<DeployKey> getProjectDeployKeysStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectDeployKeys(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public DeployKey getDeployKey(Object projectIdOrPath, Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", keyId);
        return response.readEntity(DeployKey.class);
    }

    public Optional<DeployKey> getOptionalDeployKey(Object projectIdOrPath, Long keyId) {
        try {
            return Optional.ofNullable(this.getDeployKey(projectIdOrPath, keyId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public DeployKey addDeployKey(Object projectIdOrPath, String title, String key, Boolean canPush) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("key", key, true).withParam("can_push", canPush);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys");
        return response.readEntity(DeployKey.class);
    }

    public DeployKey updateDeployKey(Object projectIdOrPath, Long deployKeyId, String title, Boolean canPush) throws GitLabApiException {
        if (deployKeyId == null) {
            throw new RuntimeException("deployKeyId cannot be null");
        }
        DeployKey key = new DeployKey();
        key.setCanPush(canPush);
        key.setTitle(title);
        Response response = this.put(Response.Status.OK, key, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", deployKeyId);
        return response.readEntity(DeployKey.class);
    }

    public void deleteDeployKey(Object projectIdOrPath, Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", keyId);
    }

    public DeployKey enableDeployKey(Object projectIdOrPath, Long keyId) throws GitLabApiException {
        if (keyId == null) {
            throw new RuntimeException("keyId cannot be null");
        }
        Response response = this.post(Response.Status.CREATED, (Form)null, "projects", this.getProjectIdOrPath(projectIdOrPath), "deploy_keys", keyId, "enable");
        return response.readEntity(DeployKey.class);
    }
}

