/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.web.exceptionhandler;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.squashtest.tm.plugin.rest.core.web.IRestController;
import org.squashtest.tm.plugin.rest.core.web.exceptionhandler.response.FieldValidationErrors;

@ControllerAdvice(assignableTypes={IRestController.class})
@Order(value=-2147483648)
public class RestApiValidationExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestApiValidationExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<FieldValidationErrors> handleValidationException(MethodArgumentNotValidException ex) {
        LOGGER.error(ex.getMessage(), (Throwable)ex);
        List<FieldValidationErrors.ValidationError> validationErrors = ex.getBindingResult().getFieldErrors().stream().map(fieldError -> FieldValidationErrors.error(fieldError.getField(), fieldError.getDefaultMessage())).toList();
        return new ResponseEntity((Object)FieldValidationErrors.withErrors(validationErrors), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<FieldValidationErrors> handleConstraintViolation(ConstraintViolationException ex) {
        LOGGER.error(ex.getMessage(), (Throwable)ex);
        List<FieldValidationErrors.ValidationError> validationErrors = ex.getConstraintViolations().stream().map(violation -> FieldValidationErrors.error(this.extractFieldName(violation.getPropertyPath()), violation.getMessage())).toList();
        return new ResponseEntity((Object)FieldValidationErrors.withErrors(validationErrors), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private String extractFieldName(Path propertyPath) {
        StringBuilder fieldName = new StringBuilder();
        int depth = 0;
        for (Path.Node node : propertyPath) {
            if (depth < 2) {
                ++depth;
                continue;
            }
            if (depth == 2) {
                fieldName.append(node.getName());
            } else {
                fieldName.append('.').append(node.getName());
            }
            ++depth;
        }
        return fieldName.toString();
    }
}

