/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import javax.annotation.concurrent.NotThreadSafe;
import org.squashtest.tm.plugin.rest.core.jackson.BaseDynamicFilter;
import org.squashtest.tm.plugin.rest.core.jackson.FilterExpression;
import org.squashtest.tm.plugin.rest.core.jackson.FilterExpressionBuilder;

@NotThreadSafe
public class SerializationDynamicFilter
extends SimpleBeanPropertyFilter {
    public static final String FILTER_ID = "squashrest";
    private BaseDynamicFilter filter;

    public SerializationDynamicFilter() {
        this("");
    }

    public SerializationDynamicFilter(String filterExpression) {
        this.filter = new BaseDynamicFilter(FilterExpressionBuilder.from(filterExpression));
    }

    public SerializationDynamicFilter(FilterExpression objExpression) {
        this.filter = new BaseDynamicFilter(objExpression);
    }

    public SerializationDynamicFilter(BaseDynamicFilter filter) {
        this.filter = filter;
    }

    public boolean include(String pptName) {
        return this.filter.include(pptName);
    }

    public SerializationDynamicFilter forCurrentBean() {
        return new SerializationDynamicFilter(this.filter.forCurrentBean());
    }

    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        this.filter.setCurrentProperty(writer.getName());
        if (this.isUnwrapping(writer)) {
            super.serializeAsField(pojo, jgen, provider, writer);
        } else if (this.filter.include()) {
            this.internalSerialize(pojo, jgen, provider, writer);
        }
    }

    private boolean isUnwrapping(PropertyWriter writer) {
        return BeanPropertyWriter.class.isAssignableFrom(writer.getClass()) && ((BeanPropertyWriter)writer).isUnwrapping();
    }

    private void internalSerialize(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        this.filter.advancePointer();
        super.serializeAsField(pojo, jgen, provider, writer);
        this.filter.resetPointer();
    }
}

