/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.mantis.MantisBugtrackerConnectorInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.CredentialHolder;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.service.MantisService;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

@Component
@Scope(value="prototype")
public class MantisBugtrackerConnector
implements AdvancedBugTrackerConnector {
    private static final String MANTIS_ISSUE_SUFFIX = "/view.php";
    private BugTracker bugtracker;
    private final MantisBugtrackerConnectorInterfaceDescriptor interfaceDescriptor;
    private final MantisService mantisService;
    private final CredentialHolder credentialHolder = new CredentialHolder();

    public MantisBugtrackerConnector(MantisBugtrackerConnectorInterfaceDescriptor interfaceDescriptor, MantisService mantisService) {
        this.interfaceDescriptor = interfaceDescriptor;
        this.mantisService = mantisService;
    }

    public AuthenticationProtocol[] getSupportedAuthProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.TOKEN_AUTH};
    }

    public URL makeViewIssueUrl(String issueId) {
        try {
            URL url;
            if (this.bugtracker.getUrl() != null) {
                URL baseUrl = new URL(this.bugtracker.getUrl());
                String suffix = "/view.php?id=" + issueId;
                url = new URL(String.valueOf(baseUrl) + suffix);
            } else {
                url = null;
            }
            return url;
        }
        catch (MalformedURLException mue) {
            throw new BugTrackerRemoteException((Throwable)mue);
        }
    }

    public AdvancedProject findProject(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        return null;
    }

    public AdvancedProject findProjectById(String s) throws ProjectNotFoundException, BugTrackerRemoteException {
        return null;
    }

    public AdvancedIssue createIssue(RemoteIssue remoteIssue) throws BugTrackerRemoteException {
        return this.mantisService.createIssue(remoteIssue, this.credentialHolder);
    }

    public Optional<AdvancedIssue> searchIssue(RemoteIssueSearchRequest searchRequest) {
        return this.mantisService.searchIssue(searchRequest, this.credentialHolder);
    }

    public AdvancedIssue findIssue(String s) {
        return null;
    }

    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        return this.mantisService.createReportIssueTemplate(projectName, context, this.credentialHolder, this.bugtracker);
    }

    public List<AdvancedIssue> findIssues(List<String> list) {
        return this.mantisService.findKnownIssues(list, this.credentialHolder);
    }

    public void forwardAttachments(String issueId, List<Attachment> attachments) {
        this.mantisService.forwardAttachments(issueId, attachments, this.credentialHolder);
    }

    public Object executeDelegateCommand(DelegateCommand delegateCommand) {
        return null;
    }

    public void linkIssues(String s, List<String> list) {
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.interfaceDescriptor;
    }

    public void authenticate(Credentials credentials) throws UnsupportedAuthenticationModeException {
        this.credentialHolder.setCredentials(credentials);
        this.mantisService.init(this.bugtracker, this.credentialHolder);
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerNoCredentialsException, BugTrackerRemoteException {
        this.authenticate(credentials);
    }

    public void setBugtracker(BugTracker bugtracker) {
        this.bugtracker = bugtracker;
    }

    public BugTracker getBugtracker() {
        return this.bugtracker;
    }
}

