/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.squashtest.tm.api.security.authentication.ConditionalOnAuthProviderProperty;
import org.squashtest.tm.plugin.security.ad.ldap.ActiveDirectoryLdapAuthenticationProperties;
import org.squashtest.tm.plugin.security.ad.ldap.ActiveDirectoryLdapAuthenticationProviderFactoryBean;
import org.squashtest.tm.plugin.security.ad.ldap.ActiveDirectoryLdapAuthenticationProviderFeatures;
import org.squashtest.tm.plugin.security.ad.ldap.CaseAwareUserDetailsMapper;
import org.squashtest.tm.plugin.security.ad.ldap.SquashActiveDirectoryLdapAuthenticationProvider;
import org.squashtest.tm.plugin.security.ad.ldap.UserDetailsServiceActiveDirectoryLdapAuthoritiesPopulator;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.security.UserDetailsService;
import org.squashtest.tm.service.user.UserManagerService;

@Configuration
@ConditionalOnAuthProviderProperty(value="ad.ldap")
@EnableConfigurationProperties(value={ActiveDirectoryLdapAuthenticationProperties.class})
public class ActiveDirectoryLdapSecurityConfig {
    @Inject
    private ActiveDirectoryLdapAuthenticationProperties authenticationProperties;
    @Inject
    @Named(value="squashtest.core.security.JdbcUserDetailsManager")
    @Lazy
    private SquashUserDetailsManager userDetailsManager;
    @Inject
    @Named(value="caseAwareUserDetailsMapper.ad.ldap")
    private CaseAwareUserDetailsMapper userDetailsMapper;
    @Inject
    @Lazy
    private UserManagerService userManagerService;

    @Bean(name={"authenticationProvider.ad.ldap"})
    public ActiveDirectoryLdapAuthenticationProviderFactoryBean activeDirectoryLdapAuthenticationProvider() {
        ActiveDirectoryLdapAuthenticationProviderFactoryBean factoryBean = new ActiveDirectoryLdapAuthenticationProviderFactoryBean();
        factoryBean.setActiveAuthenticationProvider("ad.ldap");
        factoryBean.setContextSource((LdapContextSource)this.ldapContextSource());
        ActiveDirectoryLdapAuthenticationProperties.User user = this.authenticationProperties.getUser();
        ActiveDirectoryLdapAuthenticationProperties.Server server = this.authenticationProperties.getServer();
        factoryBean.setUserSearchBase(user.getSearchBase());
        factoryBean.setUserSearchFilter(user.getSearchFilter());
        factoryBean.setUrl(server.getUrl());
        factoryBean.setDomain(server.getDomain());
        factoryBean.setAuthoritiesPopulator(new UserDetailsServiceActiveDirectoryLdapAuthoritiesPopulator((UserDetailsService)this.userDetailsManager));
        factoryBean.setUserDetailsMapper(this.userDetailsMapper);
        factoryBean.setFeatures(this.activeDirectoryLdapAuthenticationProviderFeatures());
        factoryBean.setUserManagerService(this.userManagerService);
        return factoryBean;
    }

    @Bean(name={"contextSource.ad.ldap"})
    public DefaultSpringSecurityContextSource ldapContextSource() {
        ActiveDirectoryLdapAuthenticationProperties.Server server = this.authenticationProperties.getServer();
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(server.getUrl());
        contextSource.setUserDn(server.getManagerDn());
        contextSource.setPassword(server.getManagerPassword());
        return contextSource;
    }

    @Bean
    public ActiveDirectoryLdapAuthenticationProviderFeatures activeDirectoryLdapAuthenticationProviderFeatures() {
        return ActiveDirectoryLdapAuthenticationProviderFeatures.INSTANCE;
    }

    @Configuration
    @ConditionalOnAuthProviderProperty(value="ad.ldap")
    @Order(value=1)
    public static class ActiveDirectoryLdapAuthenticationConfig
    extends GlobalAuthenticationConfigurerAdapter {
        @Inject
        @Named(value="authenticationProvider.ad.ldap")
        private SquashActiveDirectoryLdapAuthenticationProvider authenticationProvider;

        public void init(AuthenticationManagerBuilder auth) throws Exception {
            auth.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
            auth.eraseCredentials(false);
        }
    }
}

