/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.rest.admin.jackson.model.FieldMappingDto;
import org.squashtest.tm.plugin.rest.admin.service.RestFieldMappingService;
import org.squashtest.tm.plugin.rest.admin.validators.FieldMappingValidator;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController
@UseDefaultRestApiConfiguration
@ConditionalOnClass(name={"org.squashtest.tm.plugin.rest.admin.SquashAdminApiConditionalInterface"})
public class RestFieldMappingController {
    @Inject
    private BasePathAwareLinkBuildingService linkService;
    @Inject
    private RestFieldMappingService fieldMappingService;
    @Inject
    private ConfigurationService pluginService;
    @Inject
    private FieldMappingValidator fieldMappingValidator;

    @GetMapping(value={"/projects/{id}/field-mappings"})
    public ResponseEntity<PagedModel<EntityModel<FieldMapping>>> getAllFieldMappingByProject(@PathVariable(value="id") long projectId) {
        Configuration projectConfiguration = this.pluginService.getConfigurationForProject(projectId);
        List<FieldMapping> fieldMappings = projectConfiguration.getFieldMappings();
        PagedModel<EntityModel<FieldMapping>> res = this.toFieldMappingPagedResources(fieldMappings, projectId);
        return ResponseEntity.ok(res);
    }

    private PagedModel<EntityModel<FieldMapping>> toFieldMappingPagedResources(Collection<FieldMapping> content, long projectId) {
        Collection resourceCollection = content.stream().map(fieldMapping -> this.toFieldMappingResource(projectId, (FieldMapping)fieldMapping)).collect(Collectors.toList());
        PagedModel.PageMetadata metadata = new PagedModel.PageMetadata((long)resourceCollection.size(), 0L, (long)resourceCollection.size());
        LinkBuilder linkBuilder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestFieldMappingController)WebMvcLinkBuilder.methodOn(RestFieldMappingController.class, (Object[])new Object[0])).getAllFieldMappingByProject(projectId)));
        return PagedModel.of((Collection)resourceCollection, (PagedModel.PageMetadata)metadata, (Link[])new Link[]{linkBuilder.withSelfRel()});
    }

    @GetMapping(value={"/projects/{id}/field-mappings/{fieldMappingId}"})
    public ResponseEntity<EntityModel<FieldMapping>> findFieldMappingByIdForProject(@PathVariable(value="id") long projectId, @PathVariable(value="fieldMappingId") String id) {
        Configuration configuration = this.pluginService.getConfigurationForProject(projectId);
        FieldMapping fieldMapping = configuration.getFieldMapping(id);
        EntityModel<FieldMapping> res = this.toFieldMappingResource(projectId, fieldMapping);
        return ResponseEntity.ok(res);
    }

    @PostMapping(value={"/projects/{id}/field-mappings"})
    public ResponseEntity<EntityModel<FieldMapping>> createFieldMapping(@PathVariable(value="id") long projectId, @RequestBody FieldMappingDto fieldMappingDto) throws BindException {
        this.fieldMappingValidator.validatePostFieldMapping(fieldMappingDto, projectId);
        FieldMapping fieldMapping = fieldMappingDto.convertToFieldMapping();
        this.fieldMappingService.createFieldMapping(projectId, fieldMapping);
        EntityModel<FieldMapping> res = this.toFieldMappingResource(projectId, fieldMapping);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(res);
    }

    @PatchMapping(value={"/projects/{projectId}/field-mappings/{id}"})
    public ResponseEntity<EntityModel<FieldMapping>> updateFieldMapping(@PathVariable(value="projectId") long projectId, @PathVariable(value="id") String fieldMappingId, @RequestBody FieldMappingDto fieldMappingDto) throws BindException {
        this.fieldMappingValidator.validatePatchFieldMapping(fieldMappingId, fieldMappingDto, projectId);
        FieldMapping fieldMapping = this.fieldMappingService.updateFieldMapping(projectId, fieldMappingId, fieldMappingDto);
        EntityModel res = EntityModel.of((Object)fieldMapping);
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestFieldMappingController)WebMvcLinkBuilder.methodOn(RestFieldMappingController.class, (Object[])new Object[0])).findFieldMappingByIdForProject(projectId, fieldMapping.getId()))).withRel("self"));
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/projects/{projectId}/field-mappings/{ids}"})
    public ResponseEntity<Void> deleteFielMappingById(@PathVariable(value="projectId") long projectId, @PathVariable(value="ids") List<String> fieldMappingIds) {
        this.pluginService.removeFieldMappingsByIds(projectId, fieldMappingIds);
        return ResponseEntity.noContent().build();
    }

    private EntityModel<FieldMapping> toFieldMappingResource(long projectId, FieldMapping entity) {
        EntityModel resource = EntityModel.of((Object)entity);
        LinkBuilder linkBuilder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestFieldMappingController)WebMvcLinkBuilder.methodOn(RestFieldMappingController.class, (Object[])new Object[0])).findFieldMappingByIdForProject(projectId, entity.getId())));
        resource.add(linkBuilder.withSelfRel());
        return resource;
    }
}

