/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;

class ExecplanIssuePartition {
    private Map<String, ExecplanIssue> features = new HashMap<String, ExecplanIssue>();
    private Map<String, ExecplanIssue> coveredFeatures = new HashMap<String, ExecplanIssue>();
    private Map<String, ExecplanIssue> bugfixes = new HashMap<String, ExecplanIssue>();
    private Map<String, ExecplanIssue> unrelated = new HashMap<String, ExecplanIssue>();

    ExecplanIssuePartition() {
    }

    public ExecplanIssue getFeature(String key) {
        return this.features.get(key);
    }

    public ExecplanIssue getCoveredFeature(String key) {
        return this.coveredFeatures.get(key);
    }

    public ExecplanIssue getBugfix(String key) {
        return this.bugfixes.get(key);
    }

    public ExecplanIssue getUnrelated(String key) {
        return this.unrelated.get(key);
    }

    public void addFeature(ExecplanIssue feature) {
        this.features.put(feature.getKey(), feature);
    }

    public void addCoveredFeature(ExecplanIssue coveredFeature) {
        this.coveredFeatures.put(coveredFeature.getKey(), coveredFeature);
    }

    public void addBugfix(ExecplanIssue bugfix) {
        this.bugfixes.put(bugfix.getKey(), bugfix);
    }

    public void addUnrelated(ExecplanIssue feature) {
        this.unrelated.put(feature.getKey(), feature);
    }

    public Set<ExecplanIssue> getFeatures() {
        return new HashSet<ExecplanIssue>(this.features.values());
    }

    public Set<ExecplanIssue> getCoveredFeatures() {
        return new HashSet<ExecplanIssue>(this.coveredFeatures.values());
    }

    public Set<ExecplanIssue> getBugfixes() {
        return new HashSet<ExecplanIssue>(this.bugfixes.values());
    }

    public Set<ExecplanIssue> getUnrelated() {
        return new HashSet<ExecplanIssue>(this.unrelated.values());
    }

    public Set<String> getFeatureKeys() {
        return this.features.keySet();
    }

    public Set<String> getBugfixeKeys() {
        return this.bugfixes.keySet();
    }

    public Set<String> getCoveredFeatureKeys() {
        return this.coveredFeatures.keySet();
    }

    public Set<String> getUnrelatedKeys() {
        return this.unrelated.keySet();
    }

    public String log() {
        StringBuilder builder = new StringBuilder("Issue Partition : \n");
        builder.append("\tfeatures : " + String.valueOf(this.getFeatureKeys()) + "\n");
        builder.append("\tcovered features : " + String.valueOf(this.getCoveredFeatures()) + "\n");
        builder.append("\tbugfixes : " + String.valueOf(this.getBugfixeKeys()) + "\n");
        builder.append("\tunrelated : " + String.valueOf(this.getUnrelated()) + "\n");
        return builder.toString();
    }
}

