/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import com.google.api.client.util.Lists;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jirasync.com.atlassian.jira.rest.client.api.RestClientException;
import jirasync.com.atlassian.jira.rest.client.api.domain.Attachment;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueField;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueLink;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueLinkType;
import jirasync.com.atlassian.jira.rest.client.api.domain.SearchResult;
import jirasync.io.atlassian.fugue.Iterables;
import jirasync.org.codehaus.jettison.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintRequirementSyncExtender;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementFolderSyncExtenderType;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.EpicIssueType;
import org.squashtest.tm.plugin.jirasync.domain.FieldLink;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.domain.JiraSprintState;
import org.squashtest.tm.plugin.jirasync.domain.RemoteJiraIssueDto;
import org.squashtest.tm.plugin.jirasync.domain.RequirementExtenderFolderDto;
import org.squashtest.tm.plugin.jirasync.domain.SquashIssueLink;
import org.squashtest.tm.plugin.jirasync.domain.SynchronisationReport;
import org.squashtest.tm.plugin.jirasync.helpers.JiraHelper;
import org.squashtest.tm.plugin.jirasync.importer.ImporterState;
import org.squashtest.tm.plugin.jirasync.importer.JiraRequirementImporter;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssue;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;
import org.squashtest.tm.plugin.jirasync.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationManager;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingService;
import org.squashtest.tm.plugin.jirasync.service.SynchronisationEffectiveConfiguration;
import org.squashtest.tm.plugin.jirasync.service.ValueMappings;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteRequirementFinder;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteRequirementFinderFactory;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteRequirementKeys;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteSprintFinder;
import org.squashtest.tm.plugin.jirasync.service.finder.RemoteSprintFinderFactory;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.CustomSprintModificationService;
import org.squashtest.tm.service.campaign.SprintReqVersionTestPlanManagerService;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.dto.HighLevelRequirementExceptionSummary;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionLinkTypeDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.SprintRequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateRequirementLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.hibernate.utils.HibernateConfig;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squash.tm.plugin.jirasync.synchronizationService")
public class RequirementSynchronizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementSynchronizationService.class);
    public static final String JIRA_SYNC_CRON_ID = "jira.xsquash";
    public static final String PARENT_FIELD = "parent";
    public static final String STATUS = "status";
    private static final String STARTED_SYNCHRO_QUERY = "UPDATE RemoteSynchronisation SET lastSyncDate = :syncDate, synchronisationStatus = :status WHERE id = :id";
    private static final String FINAL_SYNCHRO_QUERY = "UPDATE RemoteSynchronisation SET synchronisationStatus = :status, lastSynchronisationStatus = :status WHERE id = :id";
    @Value(value="${logging.dir}")
    private String logsFolderPath;
    @Inject
    private Environment environment;
    @Inject
    private LinkedRequirementVersionManagerService linkedRequirementVersionManagerService;
    @Inject
    private Provider<JiraRequirementImporter> importerProvider;
    @Inject
    private BugTrackerFinderService serverService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private HibernateRequirementLibraryNodeDao libraryNodeDao;
    @Inject
    private SprintGroupDao sprintGroupDao;
    @Inject
    private PluginRequirementDao pluginRequirementDao;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private SprintReqVersionTestPlanManagerService sprintReqVersionTestPlanManagerService;
    @Inject
    private PlatformTransactionManager transactionManager;
    @Inject
    private ClientProvider clientProvider;
    @Inject
    private RequirementVersionLinkTypeDao requirementVersionLinkTypeDao;
    @Inject
    private RequirementSyncExtenderDao requirementSyncExtenderDao;
    @Inject
    private RequirementVersionDao requirementVersionDao;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private JiraReportingService jiraReportingService;
    @Inject
    private HighLevelRequirementService highLevelRequirementService;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    private FolderModificationService<RequirementFolder> folderModificationService;
    @Inject
    @Named(value="org.squashtest.tm.plugin.jirasync.ConfigurationManager")
    private ConfigurationManager configurationManager;
    @Inject
    private RemoteRequirementFinderFactory remoteRequirementFinderFactory;
    @Inject
    private RemoteSprintFinderFactory remoteSprintFinderFactory;
    @Inject
    private CustomSprintModificationService customSprintModificationService;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private SprintDao sprintDao;
    @Inject
    private SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao;
    @Inject
    private SprintReqVersionDao sprintReqVersionDao;
    @Inject
    private JiraRequirementImporter jiraRequirementImporter;
    @Inject
    private JiraHelper jiraHelper;
    private Map<String, String> relKeys = new HashMap<String, String>();

    @Inject
    @Named(value="squashtest.tm.service.RequirementFolderModificationService")
    public final void setFolderModificationService(FolderModificationService<RequirementFolder> folderModificationService) {
        this.folderModificationService = folderModificationService;
    }

    @PostConstruct
    public void checkLoggingFilePath() {
        String loggingFilePath = this.environment.getProperty("logging.file.path");
        if (loggingFilePath != null) {
            LOGGER.warn("Xsquash4Jira plugin : logging.file.path is no longer supported. Current value is the one defined in logging.dir");
        }
    }

    public void performFullSynchronisation() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[JIRA-SYNC] - Begin Synchronisation with JIRA.");
        }
        this.performCronAuthentication();
        try {
            List<Long> activeJiraRemoteSyncIds = this.pluginRequirementDao.findActiveJiraRemoteSyncIds();
            for (Long remoteSynchronisationId : activeJiraRemoteSyncIds) {
                this.performSynchronisation(remoteSynchronisationId);
            }
            if (!activeJiraRemoteSyncIds.isEmpty()) {
                this.jiraReportingService.performReportingToJira(activeJiraRemoteSyncIds);
            }
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    private void performCronAuthentication() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[JIRA-SYNC] - Performing cron internal authentication");
        }
        SecurityContextHolder.clearContext();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        AnonymousAuthenticationToken authentication = new AnonymousAuthenticationToken(JIRA_SYNC_CRON_ID, (Object)JIRA_SYNC_CRON_ID, authorities);
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)authentication);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[JIRA-SYNC] - Done cron internal authentication as jira.xsquash");
        }
    }

    protected void performSynchronisation(Long remoteSynchronisationId) {
        Date syncDate = new Date();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[JIRA-SYNC] -  Begin Synchronisation with JIRA for RemoteSynchronisation " + String.valueOf(remoteSynchronisationId));
        }
        this.logSyncStarted(remoteSynchronisationId, syncDate);
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        JiraClient jiraClient = null;
        SynchronisationReport finalReport = new SynchronisationReport();
        try {
            try {
                HibernateConfig.enableBatch((EntityManager)this.entityManager, (int)50);
                RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
                jiraClient = remoteSynchronisation.getOwner() != null ? this.clientProvider.createUserClient(remoteSynchronisation.getServer(), remoteSynchronisation.getOwner().getLogin()) : this.clientProvider.createAppLevelClient(remoteSynchronisation.getServer());
                JiraRemoteSynchronisation jiraRemoteSynchronisation = this.getJiraRemoteSynchronisation(remoteSynchronisation, jiraClient);
                if (jiraRemoteSynchronisation.isBoard()) {
                    this.doSynchronisationOnBoard(finalReport, jiraClient, jiraRemoteSynchronisation);
                } else {
                    this.doSynchronisationOnFilter(finalReport, jiraClient, jiraRemoteSynchronisation);
                }
                this.entityManager.flush();
                this.transactionManager.commit(transaction);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] -  Finished Synchronisation with success : " + remoteSynchronisation.toString());
                }
                finalReport.setStatus(SynchronisationStatus.SUCCESS);
            }
            catch (Throwable e) {
                this.transactionManager.rollback(transaction);
                LOGGER.error("[JIRA-SYNC] -  Error while processing remoteSynchronisation : " + String.valueOf(remoteSynchronisationId), e);
                this.createLogFile(e, remoteSynchronisationId);
                finalReport.setStatus(SynchronisationStatus.FAILURE);
                if (jiraClient != null) {
                    jiraClient.close();
                }
                this.logFinalStatus(remoteSynchronisationId, finalReport, syncDate);
            }
        }
        finally {
            if (jiraClient != null) {
                jiraClient.close();
            }
            this.logFinalStatus(remoteSynchronisationId, finalReport, syncDate);
        }
    }

    private void createLogFile(Throwable ex, Long remoteSynchronisationId) {
        File logFolder = new File(this.getPluginLogFolderPath());
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getSyncErrorLogPath(remoteSynchronisationId);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter pw = new PrintWriter(logFilePath);){
                ex.printStackTrace(pw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not generate error log file for synchronisation: (%s)", remoteSynchronisationId), (Throwable)e);
        }
    }

    public String getSyncErrorLogPath(Long syncId) {
        return String.format("%s/%s-sync-%s-error.log", this.getPluginLogFolderPath(), "xsquash4jira", syncId.toString());
    }

    private String getPluginLogFolderPath() {
        return this.logsFolderPath + "/xsquash4jira";
    }

    private void doSynchronisationOnFilter(SynchronisationReport synchronisationReport, JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        RemoteRequirementKeys issueKeys = this.findDesynchronisedIssueKeys(jiraRemoteSynchronisation, jiraClient);
        if (issueKeys.hasDesynchronizedKeys()) {
            this.doSynchronisation(jiraClient, jiraRemoteSynchronisation, issueKeys);
        }
        this.updateSquashKnownRemoteReqPerimeterStatus(jiraClient, jiraRemoteSynchronisation, issueKeys);
        synchronisationReport.setSynchronizedRequirementsCount(issueKeys.getKnown().size());
        synchronisationReport.setUnprocessedRequirementsCount(issueKeys.getUnprocessed().size());
    }

    private void updateSquashKnownRemoteReqPerimeterStatus(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, RemoteRequirementKeys issueKeys) {
        List squashPersistedRemoteReq = this.remoteSynchronisationDao.findAllReqSyncExtenderKeys(Long.valueOf(jiraRemoteSynchronisation.getId()));
        ArrayList<String> outOfSyncRemoteReq = new ArrayList<String>(CollectionUtils.removeAll((Collection)squashPersistedRemoteReq, issueKeys.getKnown()));
        String[] allSyncRemoteKeys = issueKeys.getKnown().toArray(new String[0]);
        if (allSyncRemoteKeys.length > 0) {
            String firstKnownRemoteSyncKey = allSyncRemoteKeys[0];
            List<Issue> issues = jiraClient.getIssuesByKey(outOfSyncRemoteReq, this.configurationManager.getBatchSize(), firstKnownRemoteSyncKey);
            List<String> existingRemoteReq = issues.stream().map(BasicIssue::getKey).toList();
            ArrayList<String> notFoundRemoteReq = new ArrayList<String>(CollectionUtils.removeAll(outOfSyncRemoteReq, existingRemoteReq));
            ArrayList<String> outOfPerimeterRemoteReq = new ArrayList<String>(CollectionUtils.intersection(outOfSyncRemoteReq, existingRemoteReq));
            this.updatePerimeterStatus(jiraRemoteSynchronisation.getId(), new ArrayList<String>(issueKeys.getKnown()), RemoteRequirementPerimeterStatus.IN_CURRENT_PERIMETER);
            this.updatePerimeterStatus(jiraRemoteSynchronisation.getId(), outOfPerimeterRemoteReq, RemoteRequirementPerimeterStatus.OUT_OF_CURRENT_PERIMETER);
            this.updatePerimeterStatus(jiraRemoteSynchronisation.getId(), notFoundRemoteReq, RemoteRequirementPerimeterStatus.NOT_FOUND);
        } else {
            this.updatePerimeterStatus(jiraRemoteSynchronisation.getId(), squashPersistedRemoteReq, RemoteRequirementPerimeterStatus.UNKNOWN);
        }
    }

    private void updatePerimeterStatus(Long jiraRemoteSynchronisationId, List<String> remoteReqKeys, RemoteRequirementPerimeterStatus perimeterStatus) {
        if (!remoteReqKeys.isEmpty()) {
            this.requirementSyncExtenderDao.updatePerimeter(jiraRemoteSynchronisationId, remoteReqKeys, perimeterStatus);
        }
    }

    public List<RemoteJiraIssueDto> simulateNewSynchronisation(JiraRemoteSynchronisation sync, boolean checkMaxItems) {
        List<RemoteJiraIssueDto> jiraIssues;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JiraClient jiraClient = this.getJiraClient(sync);){
                boolean isSprintSynchro = false;
                RemoteRequirementFinder remoteRequirementFinder = this.remoteRequirementFinderFactory.create(sync, jiraClient);
                if (checkMaxItems) {
                    remoteRequirementFinder.checkIfMaxNumberOfIssuesInPerimeterExceeded(isSprintSynchro);
                }
                jiraIssues = remoteRequirementFinder.findRemoteJiraIssues(isSprintSynchro);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("[JIRA-SYNC] -  Error while simulating new synchronisation", (Throwable)e);
            throw e;
        }
        return jiraIssues;
    }

    public List<JiraSprint> simulateNewSprintSynchronisation(JiraRemoteSynchronisation sync, boolean checkMaxItems) {
        List<JiraSprint> jiraSprints;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JiraClient jiraClient = this.getJiraClient(sync);){
                RemoteSprintFinder remoteSprintFinder = this.remoteSprintFinderFactory.create(sync, jiraClient);
                jiraSprints = remoteSprintFinder.findRemoteJiraSprints();
                boolean isSprintSynchro = true;
                RemoteRequirementFinder remoteRequirementFinder = this.remoteRequirementFinderFactory.create(sync, jiraClient);
                if (checkMaxItems) {
                    remoteRequirementFinder.checkIfMaxNumberOfIssuesInPerimeterExceeded(isSprintSynchro);
                }
                List<RemoteJiraIssueDto> jiraIssues = remoteRequirementFinder.findRemoteJiraIssues(isSprintSynchro);
                this.bindJiraIssuesToJiraSprints(jiraSprints, jiraIssues, jiraClient);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("[JIRA-SYNC] -  Error while simulating new synchronisation", (Throwable)e);
            throw e;
        }
        return jiraSprints;
    }

    private JiraClient getJiraClient(JiraRemoteSynchronisation synchronisation) {
        return synchronisation.getOwner() != null ? this.clientProvider.createUserClient(synchronisation.getServer(), synchronisation.getOwner().getLogin()) : this.clientProvider.createAppLevelClient(synchronisation.getServer());
    }

    private void bindJiraIssuesToJiraSprints(List<JiraSprint> jiraSprints, List<RemoteJiraIssueDto> jiraIssues, JiraClient jiraClient) {
        jiraSprints.forEach(jiraSprint -> {
            Set<String> stringIssueKeys = jiraClient.findIssuesForSprint(jiraSprint.getId());
            List<RemoteJiraIssueDto> remoteJiraIssueDtos = stringIssueKeys.stream().map(stringIssueKey -> jiraIssues.stream().filter(remoteJiraIssueDto -> remoteJiraIssueDto.getKey().equals(stringIssueKey)).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            remoteJiraIssueDtos.forEach(remoteJiraIssueDto -> remoteJiraIssueDto.setSprintName(jiraSprint.getName()));
            jiraSprint.setIssues(remoteJiraIssueDtos);
        });
    }

    private void logSyncStarted(Long remoteSynchronisationId, Date syncDate) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        this.entityManager.createQuery(STARTED_SYNCHRO_QUERY).setParameter("syncDate", (Object)syncDate).setParameter(STATUS, (Object)SynchronisationStatus.RUNNING).setParameter("id", (Object)remoteSynchronisationId).executeUpdate();
        this.entityManager.flush();
        this.entityManager.clear();
        this.transactionManager.commit(transaction);
    }

    private void logFinalStatus(Long remoteSynchronisationId, SynchronisationReport synchronisationReport, Date syncDate) {
        SynchronisationStatus synchronisationStatus = synchronisationReport.getStatus();
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        if (synchronisationStatus.equals((Object)SynchronisationStatus.SUCCESS)) {
            this.updateSynchronisationDateAndRatios(remoteSynchronisationId, synchronisationReport, syncDate);
        } else {
            this.updatePerimeterAndSprintPerimeterStatuses(remoteSynchronisationId);
        }
        this.entityManager.createQuery(FINAL_SYNCHRO_QUERY).setParameter("id", (Object)remoteSynchronisationId).setParameter(STATUS, (Object)synchronisationStatus).executeUpdate();
        this.entityManager.flush();
        this.entityManager.clear();
        this.transactionManager.commit(transaction);
    }

    private void updateSynchronisationDateAndRatios(Long remoteSynchronisationId, SynchronisationReport synchronisationReport, Date syncDate) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
        JiraRemoteSynchronisation jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
        jiraRemoteSynchronisation.setLastSuccessfulSyncDate(syncDate);
        jiraRemoteSynchronisation.setSynchronizedAndUnprocessedCounts(synchronisationReport);
    }

    private void updatePerimeterAndSprintPerimeterStatuses(Long remoteSynchronisationId) {
        if (Objects.nonNull(remoteSynchronisationId)) {
            List squashPersistedRemoteReq = this.remoteSynchronisationDao.findAllReqSyncExtenderKeys(remoteSynchronisationId);
            this.updatePerimeterStatus(remoteSynchronisationId, squashPersistedRemoteReq, RemoteRequirementPerimeterStatus.UNKNOWN);
            this.sprintRequirementSyncExtenderDao.updatePerimeterStatusByRemoteSyncId(remoteSynchronisationId, RemoteRequirementPerimeterStatus.UNKNOWN);
        }
    }

    private void createSprintFolderInRequirementWorkspace(JiraSprint jiraSprint, RemoteSynchronisation remoteSynchronisation, Long targetFolderId) {
        RequirementFolder sprintFolder = new RequirementFolder();
        sprintFolder.setName(jiraSprint.getName());
        this.requirementLibraryNavigationService.addFolderToFolder(targetFolderId.longValue(), (Folder)sprintFolder);
        RequirementFolderSyncExtender requirementFolderSyncExtender = new RequirementFolderSyncExtender();
        requirementFolderSyncExtender.setRemoteSynchronisation(remoteSynchronisation);
        requirementFolderSyncExtender.setType(RequirementFolderSyncExtenderType.SPRINT);
        requirementFolderSyncExtender.setRemoteFolderId(jiraSprint.getId().toString());
        requirementFolderSyncExtender.setRemoteFolderStatus(jiraSprint.getState().name());
        requirementFolderSyncExtender.setRequirementFolder(sprintFolder);
        sprintFolder.setRequirementFolderSyncExtender(requirementFolderSyncExtender);
        this.entityManager.persist((Object)sprintFolder);
        jiraSprint.setSquashFolderId(sprintFolder.getId());
    }

    private void doSynchronisationOnBoard(SynchronisationReport synchronisationReport, JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        RemoteRequirementKeys issueKeys;
        ArrayList<String> desyncKeys;
        Long boardId = jiraRemoteSynchronisation.getBoardId();
        List<Object> allSprints = new ArrayList();
        List<Object> sprintsForReq = new ArrayList();
        if (jiraRemoteSynchronisation.mayHaveSprints()) {
            allSprints = jiraClient.tryToGetSprints(boardId, new JiraSprintState[0]);
            sprintsForReq = jiraRemoteSynchronisation.isRestrictedToActiveSprint() ? allSprints.stream().filter(sprint -> sprint.getState() == JiraSprintState.ACTIVE).toList() : allSprints;
            Map<String, JiraSprint> sprintsMap = sprintsForReq.stream().collect(Collectors.toMap(sprint -> sprint.getId().toString(), Function.identity()));
            if (!sprintsMap.isEmpty()) {
                this.synchronizeSprintInRequirementWorkspace(jiraRemoteSynchronisation, sprintsMap, sprintsForReq);
            }
        }
        if (!(desyncKeys = (issueKeys = this.findDesynchronisedIssueKeys(jiraRemoteSynchronisation, jiraClient)).allDesynchronizedKeys()).isEmpty()) {
            this.doSynchronisation(jiraClient, jiraRemoteSynchronisation, issueKeys);
        }
        if (jiraRemoteSynchronisation.mayHaveSprints()) {
            if (jiraRemoteSynchronisation.isRestrictedToActiveSprint()) {
                this.synchroniseIssuePositionForActiveSprintOnlyBoards(jiraClient, jiraRemoteSynchronisation, sprintsForReq);
            } else if (!desyncKeys.isEmpty()) {
                this.synchroniseIssuePositionForStandardBoards(jiraClient, jiraRemoteSynchronisation, sprintsForReq, issueKeys);
            }
        }
        if (!allSprints.isEmpty() && jiraRemoteSynchronisation.isSprintSynchronisationEnable()) {
            this.synchronizeSprintInCampaignWorkspace(synchronisationReport, allSprints, jiraClient, jiraRemoteSynchronisation);
        }
        this.updateSquashKnownSprintStatusForDeletedJiraSprints(synchronisationReport, jiraRemoteSynchronisation, allSprints);
        this.updateSquashKnownRemoteReqPerimeterStatus(jiraClient, jiraRemoteSynchronisation, issueKeys);
        synchronisationReport.setSynchronizedRequirementsCount(issueKeys.getKnown().size());
        synchronisationReport.setUnprocessedRequirementsCount(issueKeys.getUnprocessed().size());
    }

    private void synchronizeSprintInRequirementWorkspace(JiraRemoteSynchronisation jiraRemoteSynchronisation, Map<String, JiraSprint> sprintByIdMap, List<JiraSprint> sprints) {
        List<RequirementExtenderFolderDto> existingSprintFolders = this.pluginRequirementDao.getReqFolderExtenderDtoBySprints(jiraRemoteSynchronisation.getId(), sprintByIdMap.keySet());
        List<JiraSprint> nonExistingSprint = this.determineNonExistingSprints(sprints, existingSprintFolders);
        if (!existingSprintFolders.isEmpty()) {
            List<Long> extenderIds = existingSprintFolders.stream().map(RequirementExtenderFolderDto::extenderId).toList();
            this.updateSprintFolderInRequirementWorkspace(extenderIds, sprintByIdMap, existingSprintFolders);
        }
        RemoteSynchronisation remoteSynchronisation = jiraRemoteSynchronisation.getRemoteSynchronisation();
        Long targetFolderId = jiraRemoteSynchronisation.getTargetFolderId();
        for (JiraSprint jiraSprint : nonExistingSprint) {
            this.createSprintFolderInRequirementWorkspace(jiraSprint, remoteSynchronisation, targetFolderId);
        }
    }

    private List<JiraSprint> determineNonExistingSprints(List<JiraSprint> sprints, List<RequirementExtenderFolderDto> existingSprintFolders) {
        if (existingSprintFolders.isEmpty()) {
            return sprints;
        }
        Set existingRemoteFolderIds = existingSprintFolders.stream().map(RequirementExtenderFolderDto::remoteFolderId).collect(Collectors.toSet());
        return sprints.stream().filter(sprint -> !existingRemoteFolderIds.contains(sprint.getId())).toList();
    }

    private void updateSprintFolderInRequirementWorkspace(List<Long> extenderIds, Map<String, JiraSprint> sprintByIdMap, List<RequirementExtenderFolderDto> existingFolders) {
        List folderExtenders = this.entityManager.createQuery("SELECT r FROM RequirementFolderSyncExtender r WHERE r.id IN :extenderIds", RequirementFolderSyncExtender.class).setParameter("extenderIds", extenderIds).getResultList();
        for (RequirementFolderSyncExtender folderExtender : folderExtenders) {
            String sprintName;
            JiraSprint jiraSprint = sprintByIdMap.get(folderExtender.getRemoteFolderId());
            RequirementExtenderFolderDto folderDto = existingFolders.stream().filter(folder -> folder.remoteFolderId().equals(jiraSprint.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find folder extender for sprint " + String.valueOf(jiraSprint.getId())));
            String stateName = jiraSprint.getState().name();
            if (!folderExtender.getRemoteFolderStatus().equals(stateName)) {
                folderExtender.setRemoteFolderStatus(stateName);
            }
            if (StringUtils.isNotBlank((CharSequence)(sprintName = jiraSprint.getName())) && !folderDto.name().equals(sprintName)) {
                this.folderModificationService.renameFolder(folderDto.folderId().longValue(), sprintName);
            }
            jiraSprint.setSquashFolderId(folderDto.folderId());
        }
    }

    private void updateSquashKnownSprintStatusForDeletedJiraSprints(SynchronisationReport synchronisationReport, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> sprints) {
        List<Long> jiraSprintIds = sprints.stream().map(JiraSprint::getId).toList();
        List orphanedSquashSprintIds = this.sprintDao.findSquashSprintIdsHavingDeletedRemoteSprint(Long.valueOf(jiraRemoteSynchronisation.getId()), jiraSprintIds);
        if (!orphanedSquashSprintIds.isEmpty()) {
            this.sprintDao.updateRemoteStateOfSynchronisedSprintsByIds(orphanedSquashSprintIds, SprintStatus.DELETED.name());
            List orphanedSprintReqVersions = this.sprintReqVersionDao.findIdsBySprintIds(orphanedSquashSprintIds);
            this.sprintRequirementSyncExtenderDao.updatePerimeterStatusForSprintReqVersions(orphanedSprintReqVersions, RemoteRequirementPerimeterStatus.UNKNOWN);
            synchronisationReport.addToUnprocessedSprintTicketsCount(orphanedSprintReqVersions.size());
        }
    }

    private void synchronizeSprintInCampaignWorkspace(SynchronisationReport synchronisationReport, List<JiraSprint> sprints, JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        RemoteRequirementFinder remoteRequirementFinder = this.remoteRequirementFinderFactory.create(jiraRemoteSynchronisation, jiraClient);
        Set<Issue> boardJiraIssues = remoteRequirementFinder.findBoardRemoteJiraIssuesWithSprintAdditionalJQL();
        Map<String, DateTime> jiraIssuesKeyAndDateInBoard = boardJiraIssues.stream().collect(Collectors.toMap(BasicIssue::getKey, Issue::getUpdateDate));
        Set<JiraAgileIssue> agileIssues = jiraClient.findIssuesForSprints(jiraRemoteSynchronisation.getBoardId(), jiraIssuesKeyAndDateInBoard.keySet());
        SynchronisationEffectiveConfiguration conf = this.getEffectiveConfiguration(jiraRemoteSynchronisation, jiraClient);
        if (jiraRemoteSynchronisation.isSprintRestrictedToActiveSprint()) {
            sprints = sprints.stream().filter(sprint -> sprint.getState().equals((Object)JiraSprintState.ACTIVE) || sprint.getState().equals((Object)JiraSprintState.CLOSED)).toList();
        }
        List<Long> sprintIds = sprints.stream().map(JiraSprint::getId).toList();
        List sprintList = this.sprintDao.findByRemoteSynchronisationIdAndRemoteSprintIds(Long.valueOf(jiraRemoteSynchronisation.getId()), sprintIds);
        Map<Long, Sprint> sprintMap = sprintList.stream().collect(Collectors.toMap(Sprint::getRemoteSprintId, sprint -> sprint));
        for (JiraSprint jiraSprint : sprints) {
            Sprint squashSprint = sprintMap.get(jiraSprint.getId());
            if (!JiraSprintState.CLOSED.equals((Object)jiraSprint.getState())) {
                Set<JiraAgileIssue> agileIssuesInSprint = agileIssues.stream().filter(issue -> Objects.nonNull(issue.getSprint()) && issue.getSprint().getId().equals(jiraSprint.getId())).collect(Collectors.toSet());
                squashSprint = this.createOrUpdateSquashSprint(jiraSprint, squashSprint, jiraRemoteSynchronisation);
                RemoteRequirementKeys currentJiraIssueKeys = remoteRequirementFinder.findRemoteSprintRequirementKeys(jiraIssuesKeyAndDateInBoard, agileIssuesInSprint, squashSprint.getId());
                this.synchroniseSprintInCampaignWorkspace(jiraSprint, squashSprint, currentJiraIssueKeys, conf, jiraClient, jiraRemoteSynchronisation);
                this.updateSquashKnowSprintReqVersionPerimeterStatus(jiraClient, currentJiraIssueKeys, squashSprint);
                synchronisationReport.addToSynchronizedSprintTicketsCount(currentJiraIssueKeys.getKnown().size());
                synchronisationReport.addToUnprocessedSprintTicketsCount(currentJiraIssueKeys.getUnprocessed().size());
                continue;
            }
            if (!Objects.nonNull(squashSprint)) continue;
            this.updateSprintFolderInCampaignWorkspace(jiraSprint, squashSprint);
            synchronisationReport.addToUnprocessedSprintTicketsCount(squashSprint.getSprintReqVersions().size());
        }
    }

    private Sprint createOrUpdateSquashSprint(JiraSprint jiraSprint, Sprint squashSprint, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        if (squashSprint == null) {
            return this.createSprintInCampaignWorkspace(jiraSprint, jiraRemoteSynchronisation);
        }
        this.updateSprintFolderInCampaignWorkspace(jiraSprint, squashSprint);
        return squashSprint;
    }

    private void updateSquashKnowSprintReqVersionPerimeterStatus(JiraClient jiraClient, RemoteRequirementKeys currentJiraIssueKeys, Sprint squashSprint) {
        Long squashSprintId = squashSprint.getId();
        List squashPersistedRemoteReq = this.sprintRequirementSyncExtenderDao.findRemoteKeysBySprintIds(Collections.singletonList(squashSprintId));
        ArrayList<String> outOfSyncRemoteReq = new ArrayList<String>(CollectionUtils.removeAll((Collection)squashPersistedRemoteReq, currentJiraIssueKeys.getKnown()));
        String[] allSyncRemoteKeys = currentJiraIssueKeys.getKnown().toArray(new String[0]);
        if (allSyncRemoteKeys.length > 0) {
            String firstKnownRemoteSyncKey = allSyncRemoteKeys[0];
            List<Issue> issues = jiraClient.getIssuesByKey(outOfSyncRemoteReq, this.configurationManager.getBatchSize(), firstKnownRemoteSyncKey);
            List<String> existingRemoteReqKeys = issues.stream().map(BasicIssue::getKey).toList();
            this.updateInCurrentPerimeterSprintReqVersionPerimeterStatus(currentJiraIssueKeys, squashSprintId);
            this.updateOutOfPerimeterSprintReqVersionPerimeterStatus(outOfSyncRemoteReq, existingRemoteReqKeys, squashSprintId);
            this.updateNotFoundSprintReqVersionPerimeterStatus(outOfSyncRemoteReq, existingRemoteReqKeys, squashSprintId);
        } else {
            this.updateSprintPerimeterStatus(squashPersistedRemoteReq, squashSprintId, RemoteRequirementPerimeterStatus.UNKNOWN);
        }
    }

    private void updateInCurrentPerimeterSprintReqVersionPerimeterStatus(RemoteRequirementKeys currentJiraIssueKeys, Long squashSprintId) {
        this.updateSprintPerimeterStatus(new ArrayList<String>(currentJiraIssueKeys.getKnown()), squashSprintId, RemoteRequirementPerimeterStatus.IN_CURRENT_PERIMETER);
    }

    private void updateOutOfPerimeterSprintReqVersionPerimeterStatus(List<String> outOfSyncRemoteReq, List<String> existingRemoteReqKeys, Long squashSprintId) {
        ArrayList<String> outOfPerimeterRemoteReqKeys = new ArrayList<String>(CollectionUtils.intersection(outOfSyncRemoteReq, existingRemoteReqKeys));
        this.updateSprintPerimeterStatus(outOfPerimeterRemoteReqKeys, squashSprintId, RemoteRequirementPerimeterStatus.OUT_OF_CURRENT_PERIMETER);
    }

    private void updateNotFoundSprintReqVersionPerimeterStatus(List<String> outOfSyncRemoteReq, List<String> existingRemoteReqKeys, Long squashSprintId) {
        ArrayList<String> notFoundRemoteReqKeys = new ArrayList<String>(CollectionUtils.removeAll(outOfSyncRemoteReq, existingRemoteReqKeys));
        this.updateSprintPerimeterStatus(notFoundRemoteReqKeys, squashSprintId, RemoteRequirementPerimeterStatus.NOT_FOUND);
    }

    private void updateSprintPerimeterStatus(List<String> remoteReqKeys, Long squashSprintId, RemoteRequirementPerimeterStatus perimeterStatus) {
        if (!remoteReqKeys.isEmpty()) {
            this.sprintRequirementSyncExtenderDao.updatePerimeterStatus(remoteReqKeys, squashSprintId, perimeterStatus);
        }
    }

    private SynchronisationEffectiveConfiguration getEffectiveConfiguration(JiraRemoteSynchronisation jiraRemoteSynchronisation, JiraClient jiraClient) {
        Configuration conf = this.confService.getConfigurationForProject(jiraRemoteSynchronisation.getRemoteSynchronisation());
        return jiraClient.createEffectiveConfiguration(conf);
    }

    private void createUpdateSprintRequirementsFromJiraIssuesInBatch(SynchronisationEffectiveConfiguration conf, Set<Issue> issues, Map<String, String> issuesKeyDescriptionMap, RemoteRequirementKeys issueKeys, Sprint squashSprint, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        issues.forEach(jiraIssue -> {
            String htmlDescription = this.buildIssueDescription(jiraRemoteSynchronisation, (Issue)jiraIssue, issuesKeyDescriptionMap);
            if (issueKeys.getToCreate().contains(jiraIssue.getKey())) {
                this.createSprintRequirementVersion(conf, (Issue)jiraIssue, squashSprint, htmlDescription);
            } else if (issueKeys.getToUpdate().contains(jiraIssue.getKey())) {
                SprintRequirementSyncExtender sprintReqSyncExtender = this.sprintRequirementSyncExtenderDao.findBySprintIdRemoteSyncIdAndRemoteReqId(squashSprint.getId().longValue(), squashSprint.getRemoteSynchronisation().getId(), jiraIssue.getKey());
                this.updateSprintRequirementVersion(conf, sprintReqSyncExtender, (Issue)jiraIssue, htmlDescription);
            }
        });
    }

    private String buildIssueDescription(JiraRemoteSynchronisation jiraRemoteSynchronisation, Issue issue, Map<String, String> issuesKeyDescriptionMap) {
        boolean isJiraCloudServer = this.jiraRequirementImporter.isJiraCloudServer(jiraRemoteSynchronisation);
        ArrayList<Attachment> att = issue.getAttachments() != null ? issue.getAttachments() : new ArrayList<Attachment>();
        return this.jiraRequirementImporter.buildHtmlDescription(isJiraCloudServer, att, issuesKeyDescriptionMap.get(issue.getKey()));
    }

    private void synchroniseSprintInCampaignWorkspace(JiraSprint jiraSprint, Sprint squashSprint, RemoteRequirementKeys issueKeys, SynchronisationEffectiveConfiguration conf, JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        block5: {
            if (squashSprint != null && issueKeys.hasDesynchronizedKeys() && !JiraSprintState.CLOSED.equals((Object)jiraSprint.getState())) {
                Set<String> jiraFields = conf.getQueryFields();
                try {
                    boolean isJiraCloudServer = this.jiraRequirementImporter.isJiraCloudServer(jiraRemoteSynchronisation);
                    if (isJiraCloudServer) {
                        this.processIssuesInBatchesCloud(issueKeys, jiraClient, jiraFields, conf, squashSprint, jiraRemoteSynchronisation);
                    } else {
                        this.processIssuesInBatches(issueKeys, jiraClient, jiraFields, conf, squashSprint, jiraRemoteSynchronisation);
                    }
                }
                catch (RestClientException exception) {
                    if (!LOGGER.isTraceEnabled()) break block5;
                    LOGGER.trace("encountered exception on fetching filled Jira issues in requirement sprint", (Throwable)exception);
                }
            }
        }
    }

    private void processIssuesInBatches(RemoteRequirementKeys issueKeys, JiraClient jiraClient, Set<String> jiraFields, SynchronisationEffectiveConfiguration conf, Sprint squashSprint, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        int incr;
        int processed = 0;
        int total = 0;
        int batchSize = this.configurationManager.getBatchSize();
        do {
            total = issueKeys.allDesynchronizedKeys().size();
            List<String> subList = issueKeys.allDesynchronizedKeys().subList(processed, Math.min(processed + batchSize, total));
            SearchResult res = jiraClient.getIssuesForFilter(subList, jiraFields, 0, batchSize).claim();
            Map<String, String> issuesKeyDescriptionMap = jiraClient.getIssuesDescription(subList, batchSize, false);
            HashSet<Issue> issues = new HashSet<Issue>(Lists.newArrayList(res.getIssues()));
            this.createUpdateSprintRequirementsFromJiraIssuesInBatch(conf, issues, issuesKeyDescriptionMap, issueKeys, squashSprint, jiraRemoteSynchronisation);
        } while ((processed += (incr = Math.min(batchSize, total - processed))) < total);
    }

    private void processIssuesInBatchesCloud(RemoteRequirementKeys issueKeys, JiraClient jiraClient, Set<String> jiraFields, SynchronisationEffectiveConfiguration conf, Sprint squashSprint, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        SearchResult res;
        int batchSize = this.configurationManager.getBatchSize();
        String nextPageToken = null;
        do {
            res = jiraClient.getIssuesForFilterCloud(issueKeys.allDesynchronizedKeys(), jiraFields, nextPageToken, batchSize).claim();
            Map<String, String> issuesKeyDescriptionMap = jiraClient.getIssuesDescription(issueKeys.allDesynchronizedKeys(), batchSize, true);
            HashSet<Issue> issues = new HashSet<Issue>(Lists.newArrayList(res.getIssues()));
            this.createUpdateSprintRequirementsFromJiraIssuesInBatch(conf, issues, issuesKeyDescriptionMap, issueKeys, squashSprint, jiraRemoteSynchronisation);
        } while ((nextPageToken = res.getNextPageToken()) != null);
    }

    private Sprint createSprintInCampaignWorkspace(JiraSprint jiraSprint, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        Sprint sprint = new Sprint();
        sprint.setName(jiraSprint.getName());
        sprint.setRemoteSynchronisation(jiraRemoteSynchronisation.getRemoteSynchronisation());
        sprint.setRemoteName(jiraSprint.getName());
        sprint.setRemoteState(jiraSprint.getState().name());
        sprint.setStatus(this.getSquashSprintStatusFromJiraStatus(jiraSprint.getState()));
        sprint.setStartDate(jiraSprint.getStartDate());
        sprint.setEndDate(jiraSprint.getCompleteDate());
        sprint.setRemoteSprintId(jiraSprint.getId());
        this.campaignLibraryNavigationService.addSprintToSprintGroup(jiraRemoteSynchronisation.getTargetSprintGroupId().longValue(), sprint);
        return sprint;
    }

    private void updateSprintFolderInCampaignWorkspace(JiraSprint jiraSprint, Sprint squashSprint) {
        String sprintName = jiraSprint.getName();
        if (!squashSprint.getRemoteName().equals(sprintName)) {
            this.customSprintModificationService.rename(squashSprint.getId().longValue(), sprintName);
            squashSprint.setRemoteName(sprintName);
        }
        squashSprint.setRemoteState(jiraSprint.getState().name());
        if (jiraSprint.getCompleteDate() != null && !jiraSprint.getCompleteDate().equals(squashSprint.getEndDate())) {
            squashSprint.setEndDate(jiraSprint.getCompleteDate());
        }
    }

    private SprintStatus getSquashSprintStatusFromJiraStatus(JiraSprintState jiraSprintStatus) {
        return switch (jiraSprintStatus) {
            case JiraSprintState.CLOSED -> SprintStatus.CLOSED;
            case JiraSprintState.ACTIVE -> SprintStatus.OPEN;
            case JiraSprintState.FUTURE -> SprintStatus.UPCOMING;
            default -> throw new MatchException(null, null);
        };
    }

    private void createSprintRequirementVersion(SynchronisationEffectiveConfiguration conf, Issue jiraIssue, Sprint squashSprint, String htmlDescription) {
        RequirementVersion reqVersion = this.requirementVersionDao.findByRemoteSyncIdAndIssueKey(Long.valueOf(squashSprint.getRemoteSynchronisation().getId()), jiraIssue.getKey());
        SprintReqVersion sprintReqVersion = new SprintReqVersion(squashSprint);
        sprintReqVersion.setReference(jiraIssue.getKey());
        sprintReqVersion.setName(jiraIssue.getSummary());
        sprintReqVersion.setStatus(jiraIssue.getStatus().getName());
        sprintReqVersion.setCategory(jiraIssue.getIssueType().getName());
        sprintReqVersion.setCriticality(this.extractCriticalityFromJiraIssue(conf, jiraIssue));
        sprintReqVersion.setDescription(htmlDescription);
        sprintReqVersion.setMode(ManagementMode.SYNCHRONIZED);
        if (Objects.nonNull(reqVersion)) {
            sprintReqVersion.setRequirementVersion(reqVersion);
        }
        this.entityManager.persist((Object)sprintReqVersion);
        this.sprintReqVersionTestPlanManagerService.addAllTestPlanItemsToSprintReqVersion(sprintReqVersion.getId());
        SprintRequirementSyncExtender sprintRequirementSyncExtender = new SprintRequirementSyncExtender();
        sprintRequirementSyncExtender.setSprintReqVersion(sprintReqVersion);
        sprintRequirementSyncExtender.setRemoteSynchronisation(squashSprint.getRemoteSynchronisation());
        sprintRequirementSyncExtender.setRemoteLastUpdated(jiraIssue.getUpdateDate().toDate());
        sprintRequirementSyncExtender.setRemoteProjectId(jiraIssue.getProject().getKey());
        sprintRequirementSyncExtender.setRemoteReqId(jiraIssue.getKey());
        String url = StringUtils.appendIfMissing((String)squashSprint.getRemoteSynchronisation().getServer().getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "browse/" + jiraIssue.getKey();
        try {
            sprintRequirementSyncExtender.setRemoteReqUrl(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn("Could not set URL correctly for issue '" + jiraIssue.getKey() + "'");
        }
        this.entityManager.persist((Object)sprintRequirementSyncExtender);
    }

    private void updateSprintRequirementVersion(SynchronisationEffectiveConfiguration conf, SprintRequirementSyncExtender sprintReqSyncExtender, Issue jiraIssue, String htmlDescription) {
        if (Objects.nonNull(sprintReqSyncExtender)) {
            sprintReqSyncExtender.setRemoteLastUpdated(jiraIssue.getUpdateDate().toDate());
            SprintReqVersion sprintReqVersion = sprintReqSyncExtender.getSprintReqVersion();
            this.checkAndUpdateReference(sprintReqVersion, jiraIssue);
            this.checkAndUpdateName(sprintReqVersion, jiraIssue);
            this.checkAndUpdateStatus(sprintReqVersion, jiraIssue);
            this.checkAndUpdateCriticality(conf, sprintReqVersion, jiraIssue);
            this.checkAndUpdateCategory(sprintReqVersion, jiraIssue);
            this.checkAndUpdateDescription(sprintReqVersion, htmlDescription);
        }
    }

    private void checkAndUpdateReference(SprintReqVersion sprintReqVersion, Issue jiraIssue) {
        if (!sprintReqVersion.getReference().equals(jiraIssue.getKey())) {
            sprintReqVersion.setReference(jiraIssue.getKey());
        }
    }

    private void checkAndUpdateName(SprintReqVersion sprintReqVersion, Issue jiraIssue) {
        if (!sprintReqVersion.getName().equals(jiraIssue.getSummary())) {
            sprintReqVersion.setName(jiraIssue.getSummary());
        }
    }

    private void checkAndUpdateStatus(SprintReqVersion sprintReqVersion, Issue jiraIssue) {
        if (Objects.nonNull(jiraIssue.getStatus()) && !jiraIssue.getStatus().getName().equals(sprintReqVersion.getStatus())) {
            sprintReqVersion.setStatus(jiraIssue.getStatus().getName());
        }
    }

    private void checkAndUpdateCriticality(SynchronisationEffectiveConfiguration conf, SprintReqVersion sprintReqVersion, Issue jiraIssue) {
        String currentJiraValue = this.extractCriticalityFromJiraIssue(conf, jiraIssue);
        if (!sprintReqVersion.getCriticality().equals(currentJiraValue)) {
            sprintReqVersion.setCriticality(currentJiraValue);
        }
    }

    private void checkAndUpdateCategory(SprintReqVersion sprintReqVersion, Issue jiraIssue) {
        if (Objects.nonNull(jiraIssue.getIssueType()) && !sprintReqVersion.getCategory().equals(jiraIssue.getIssueType().getName())) {
            sprintReqVersion.setCategory(jiraIssue.getIssueType().getName());
        }
    }

    private void checkAndUpdateDescription(SprintReqVersion sprintReqVersion, String htmlDescription) {
        if (!htmlDescription.equals(sprintReqVersion.getDescription())) {
            sprintReqVersion.setDescription(htmlDescription);
        }
    }

    private String extractCriticalityFromJiraIssue(SynchronisationEffectiveConfiguration conf, Issue jiraIssue) {
        Map<String, SynchronisationEffectiveConfiguration.EffectiveMapping> mappings = conf.getFieldMappings();
        SynchronisationEffectiveConfiguration.EffectiveMapping criticalityMapping = mappings.get(BuiltinSquashField.CRITICALITY.name());
        return this.jiraHelper.getFieldValue(jiraIssue, criticalityMapping).getFirst();
    }

    private void synchroniseIssuePositionForActiveSprintOnlyBoards(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> activeSprints) {
        for (JiraSprint activeSprint : activeSprints) {
            Collection issuesThatShouldMoveOutSprintFolder;
            Set<Long> reqIdsToMoveOutSprint;
            Set<String> issuesInSquashSprintFolder;
            Set<String> issuesInJiraSprint = jiraClient.findIssuesForSprint(activeSprint.getId());
            Collection issuesThatShouldMoveToSprintFolder = CollectionUtils.removeAll(issuesInJiraSprint, issuesInSquashSprintFolder = this.pluginRequirementDao.findIssueKeyInSprintSubFolder(jiraRemoteSynchronisation.getId(), activeSprint.getSquashFolderId()));
            Set<Long> reqIdsToMoveInSprint = this.findReqThatShouldMove(jiraRemoteSynchronisation, issuesThatShouldMoveToSprintFolder);
            if (!reqIdsToMoveInSprint.isEmpty()) {
                this.requirementLibraryNavigationService.moveNodesToFolder(activeSprint.getSquashFolderId().longValue(), reqIdsToMoveInSprint.toArray(new Long[reqIdsToMoveInSprint.size()]));
            }
            if ((reqIdsToMoveOutSprint = this.findReqThatShouldMove(jiraRemoteSynchronisation, issuesThatShouldMoveOutSprintFolder = CollectionUtils.removeAll(issuesInSquashSprintFolder, issuesInJiraSprint))).isEmpty()) continue;
            this.requirementLibraryNavigationService.moveNodesToFolder(jiraRemoteSynchronisation.getTargetFolderId().longValue(), reqIdsToMoveOutSprint.toArray(new Long[reqIdsToMoveOutSprint.size()]));
        }
    }

    private Set<Long> findReqThatShouldMove(JiraRemoteSynchronisation jiraRemoteSynchronisation, Collection<String> issuesThatShouldMoveToSprintFolder) {
        return this.pluginRequirementDao.findReqIdEligibleToBeMoved(jiraRemoteSynchronisation.getId(), issuesThatShouldMoveToSprintFolder, jiraRemoteSynchronisation.getTargetFolderId());
    }

    private void synchroniseIssuePositionForStandardBoards(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> sprints, RemoteRequirementKeys desynchronisedIssueKeys) {
        Long boardId = jiraRemoteSynchronisation.getBoardId();
        ArrayList<String> desyncKeys = desynchronisedIssueKeys.allDesynchronizedKeys();
        Set<String> updatedIssues = desynchronisedIssueKeys.getToUpdate();
        Collection<String> movedIssuesToBacklog = this.moveIssuesToBacklog(jiraClient, jiraRemoteSynchronisation, boardId, updatedIssues);
        Collection issuesInSprints = CollectionUtils.removeAll(desyncKeys, movedIssuesToBacklog);
        this.moveIssuesToSprints(jiraClient, jiraRemoteSynchronisation, sprints, issuesInSprints);
    }

    private void moveIssuesToSprints(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> sprints, Collection<String> issuesInSprints) {
        MultiMap moveOrder = this.findMoveOrderToSprints(jiraClient, jiraRemoteSynchronisation, sprints, issuesInSprints);
        for (Object id : moveOrder.keySet()) {
            Long folderId = (Long)id;
            List reqIds = (List)moveOrder.get((Object)folderId);
            this.requirementLibraryNavigationService.moveNodesToFolder(folderId.longValue(), reqIds.toArray(new Long[0]));
        }
    }

    private MultiMap findMoveOrderToSprints(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, List<JiraSprint> sprints, Collection<String> issuesInSprints) {
        Long boardId = jiraRemoteSynchronisation.getBoardId();
        MultiValueMap moveOrder = MultiValueMap.decorate(new HashMap());
        Map sprintById = sprints.stream().collect(Collectors.toMap(JiraSprint::getId, Function.identity()));
        Set<JiraAgileIssue> agileIssues = jiraClient.findIssuesForSprints(boardId, issuesInSprints);
        Set<String> keys = agileIssues.stream().map(JiraAgileIssue::getKey).collect(Collectors.toSet());
        Map<String, Long> eligibleToBeMoved = this.pluginRequirementDao.findReqIdAndJiraKeyEligibleToBeMoved(jiraRemoteSynchronisation.getId(), keys, jiraRemoteSynchronisation.getTargetFolderId());
        agileIssues = agileIssues.stream().filter(agileIssue -> agileIssue.getSprint() != null && eligibleToBeMoved.containsKey(agileIssue.getKey())).collect(Collectors.toSet());
        for (JiraAgileIssue agileIssue2 : agileIssues) {
            String issueKey = agileIssue2.getKey();
            JiraSprint sprint = (JiraSprint)sprintById.get(agileIssue2.getSprint().getId());
            if (Objects.nonNull(sprint)) {
                if (this.pluginRequirementDao.isRequirementInSynchronizedFolder(jiraRemoteSynchronisation.getId(), issueKey, sprint.getSquashFolderId())) continue;
                moveOrder.put((Object)sprint.getSquashFolderId(), (Object)this.requirementSyncExtenderDao.findRequirementIdByIssueKeyAndRemoteSyncId(issueKey, Long.valueOf(jiraRemoteSynchronisation.getId())));
                continue;
            }
            throw new IllegalArgumentException("Programmatic error : The sprint  " + agileIssue2.getSprint().getName() + " has not be synchronized");
        }
        return moveOrder;
    }

    private Collection<String> moveIssuesToBacklog(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, Long boardId, Collection<String> updatedIssues) {
        Set<Long> requirementEligibleToBeMoved;
        Set<String> issuesForBackLog = jiraClient.findIssuesForBackLog(boardId);
        Collection issuesThatShouldMoveIntoBackLog = CollectionUtils.intersection(updatedIssues, issuesForBackLog);
        if (!issuesThatShouldMoveIntoBackLog.isEmpty() && !(requirementEligibleToBeMoved = this.pluginRequirementDao.findReqIdEligibleToBeMoved(jiraRemoteSynchronisation.getId(), issuesThatShouldMoveIntoBackLog, jiraRemoteSynchronisation.getTargetFolderId())).isEmpty()) {
            this.requirementLibraryNavigationService.moveNodesToFolder(jiraRemoteSynchronisation.getTargetFolderId().longValue(), requirementEligibleToBeMoved.toArray(new Long[0]));
        }
        return issuesThatShouldMoveIntoBackLog;
    }

    private JiraRemoteSynchronisation getJiraRemoteSynchronisation(RemoteSynchronisation remoteSynchronisation, JiraClient jiraClient) {
        JiraRemoteSynchronisation jiraRemoteSynchronisation;
        if (remoteSynchronisation.getSelectType().equals(JiraSelectType.BOARD.name())) {
            JiraBoard board = jiraClient.getBoard(remoteSynchronisation.getSelectValue());
            if (board == null) {
                throw new IllegalArgumentException("The board " + remoteSynchronisation.getSelectValue() + "doesn't exist on this jira server " + remoteSynchronisation.getServer().getUrl());
            }
            jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation, board);
        } else {
            jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
        }
        Long targetFolderId = this.validateSynchronisationTargetFolder(jiraRemoteSynchronisation);
        if (jiraRemoteSynchronisation.isSprintSynchronisationEnable()) {
            Long targetSprintGroupId = this.validateTargetSprintGroup(jiraRemoteSynchronisation);
            jiraRemoteSynchronisation.setTargetSprintGroupId(targetSprintGroupId);
        }
        jiraRemoteSynchronisation.setTargetFolderId(targetFolderId);
        return jiraRemoteSynchronisation;
    }

    private void doSynchronisation(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, RemoteRequirementKeys desynchronisedIssueKeys) {
        LOGGER.trace("Initiating synchronization");
        Configuration conf = this.confService.getConfigurationForProject(jiraRemoteSynchronisation.getRemoteSynchronisation());
        LOGGER.trace("Initiating synchronization client");
        LOGGER.trace("fetching metadata and creating effective configuration");
        SynchronisationEffectiveConfiguration effective = jiraClient.createEffectiveConfiguration(conf);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Effective configuration completed as follow : ");
            LOGGER.trace(effective.toString());
        }
        Set<String> jiraFields = effective.getQueryFields();
        if (effective.getEpicLinkId() != null) {
            jiraFields.add(effective.getEpicLinkId());
        }
        Long projectId = jiraRemoteSynchronisation.getProject().getId();
        Long serverId = jiraRemoteSynchronisation.getServer().getId();
        JiraRequirementImporter importer = this.createImporter(serverId, projectId, effective);
        ImporterState state = new ImporterState();
        importer.setState(state);
        ArrayList<String> allKeys = desynchronisedIssueKeys.allDesynchronizedKeys();
        ArrayList<Map<Issue, RequirementVersionInstruction>> squashReqs = new ArrayList<Map<Issue, RequirementVersionInstruction>>();
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Processing remote synchronisation : " + jiraRemoteSynchronisation.toString());
            }
            this.synchronizeIssuesInBatches(jiraClient, jiraRemoteSynchronisation, desynchronisedIssueKeys, importer, state, allKeys, jiraFields, squashReqs);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Remote Synchronisation " + jiraRemoteSynchronisation.toString() + " done processing");
            }
            this.processAssociationsInSquash(jiraClient, jiraRemoteSynchronisation, effective, projectId, squashReqs);
        }
        catch (RestClientException exception) {
            LOGGER.error("encountered exception on fetch, which will be added to the synchronization report : ", (Throwable)exception);
        }
        this.processSubTaskRelationship(jiraRemoteSynchronisation, allKeys);
    }

    private void synchronizeIssuesInBatches(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, RemoteRequirementKeys desynchronisedIssueKeys, JiraRequirementImporter importer, ImporterState state, ArrayList<String> allKeys, Set<String> jiraFields, List<Map<Issue, RequirementVersionInstruction>> squashReqs) {
        int incr;
        int processed = 0;
        int total = 0;
        int batchSize = this.configurationManager.getBatchSize();
        boolean isJiraCloudServer = this.jiraRequirementImporter.isJiraCloudServer(jiraRemoteSynchronisation);
        do {
            total = allKeys.size();
            List<String> subList = allKeys.subList(processed, Math.min(processed + batchSize, total));
            SearchResult res = isJiraCloudServer ? jiraClient.getIssuesForFilterCloud(subList, jiraFields, null, batchSize).claim() : jiraClient.getIssuesForFilter(subList, jiraFields, 0, batchSize).claim();
            Map<String, String> issuesDescription = jiraClient.getIssuesDescription(subList, batchSize, isJiraCloudServer);
            squashReqs.add(importer.importJiraTickets(res.getIssues(), jiraRemoteSynchronisation, desynchronisedIssueKeys, issuesDescription));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("retrieved {} issues in this batch", (Object)Iterables.size(res.getIssues()));
            }
            state.setHasAllFetchFailed(false);
        } while ((processed += (incr = Math.min(batchSize, total - processed))) < total);
    }

    private void processAssociationsInSquash(JiraClient jiraClient, JiraRemoteSynchronisation jiraRemoteSynchronisation, SynchronisationEffectiveConfiguration effective, Long projectId, List<Map<Issue, RequirementVersionInstruction>> squashReqs) {
        Map<Issue, RequirementVersionInstruction> squashReqsMap = this.getSquashRequirements(squashReqs);
        List<FieldLink> fieldLinks = this.getConfiguredFieldLinks(projectId);
        if (!fieldLinks.isEmpty()) {
            LOGGER.trace("associate links to requirements");
            this.associateLinksToSquashReqs(jiraClient, squashReqsMap, effective, fieldLinks, jiraRemoteSynchronisation.getId());
        }
        Set<String> associatedKeys = this.associateRequirements(squashReqsMap.keySet(), effective.getEpicLinkId(), jiraRemoteSynchronisation, jiraClient);
        this.unlinkDeprecatedAssociations(squashReqsMap, effective.getEpicLinkId(), associatedKeys, jiraRemoteSynchronisation);
    }

    private void unlinkDeprecatedAssociations(Map<Issue, RequirementVersionInstruction> squashReqsMap, String epicLinkId, Set<String> associatedKeys, JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        List<Issue> issues = squashReqsMap.keySet().stream().filter(issue -> !associatedKeys.contains(issue.getKey())).toList();
        List<Long> requirementIds = this.searchDeprecatedRequirementAssociations(issues, epicLinkId, jiraRemoteSynchronisation);
        requirementIds.forEach(requirementId -> this.highLevelRequirementService.unlinkToHighLevelRequirement(requirementId));
    }

    private List<Long> searchDeprecatedRequirementAssociations(List<Issue> issues, String epicLinkId, JiraRemoteSynchronisation remoteSynchronisation) {
        ArrayList<Long> requirementIdsToDisassociate = new ArrayList<Long>();
        List<String> issueKeys = issues.stream().map(BasicIssue::getKey).toList();
        Map<String, List<Long>> requirementIdsByIssueKey = this.pluginRequirementDao.getRequirementIdsByIssueKeyLinkedToHLR(issueKeys, remoteSynchronisation);
        if (!requirementIdsByIssueKey.isEmpty()) {
            this.filterIssuesNeedToBeDisassociate(issues, epicLinkId, requirementIdsToDisassociate, requirementIdsByIssueKey, remoteSynchronisation);
        }
        return requirementIdsToDisassociate;
    }

    private void filterIssuesNeedToBeDisassociate(List<Issue> issuesHaveNotBeenAssociatedInSynchro, String epicLinkId, List<Long> requirementIdsToDisassociate, Map<String, List<Long>> requirementIdsByIssueKey, JiraRemoteSynchronisation remoteSynchronisation) {
        List<Issue> issues = issuesHaveNotBeenAssociatedInSynchro.stream().filter(issue -> requirementIdsByIssueKey.containsKey(issue.getKey())).toList();
        this.appendIssueToDisassociateIfNecessary(epicLinkId, requirementIdsToDisassociate, requirementIdsByIssueKey, issues, remoteSynchronisation);
    }

    private void appendIssueToDisassociateIfNecessary(String epicLinkId, List<Long> requirementIdsToDisassociate, Map<String, List<Long>> requirementIdsByIssueKey, List<Issue> issues, JiraRemoteSynchronisation remoteSynchronisation) {
        Map<String, String> jiraEpicKeyByIssueKey = this.getJiraEpicKeyByIssueKey(epicLinkId, requirementIdsToDisassociate, requirementIdsByIssueKey, issues);
        if (!jiraEpicKeyByIssueKey.isEmpty()) {
            Map<String, String> squashEpicKeyByIssueKey = this.pluginRequirementDao.getEpicKeyByIssueKeyInSquash(jiraEpicKeyByIssueKey, remoteSynchronisation);
            ArrayList disassociatedKeys = new ArrayList();
            jiraEpicKeyByIssueKey.forEach((jiraIssueKey, jiraEpicKey) -> {
                String squashEpicKey = (String)squashEpicKeyByIssueKey.get(jiraIssueKey);
                if (Objects.nonNull(squashEpicKey) && !squashEpicKey.equals(jiraEpicKey)) {
                    disassociatedKeys.add(jiraIssueKey);
                }
            });
            disassociatedKeys.forEach(issueKey -> {
                boolean bl = requirementIdsToDisassociate.addAll((Collection)requirementIdsByIssueKey.get(issueKey));
            });
        }
    }

    private Map<String, String> getJiraEpicKeyByIssueKey(String epicLinkId, List<Long> requirementIdsToDisassociate, Map<String, List<Long>> requirementIdsByIssueKey, List<Issue> issues) {
        HashMap<String, String> jiraEpicKeyByIssueKey = new HashMap<String, String>();
        issues.forEach(issue -> {
            IssueField issueField = issue.getField(epicLinkId);
            if (issueField != null) {
                String epicKey = (String)issueField.getValue();
                if (epicKey != null) {
                    jiraEpicKeyByIssueKey.put(issue.getKey(), epicKey);
                } else {
                    requirementIdsToDisassociate.addAll((Collection)requirementIdsByIssueKey.get(issue.getKey()));
                }
            }
        });
        return jiraEpicKeyByIssueKey;
    }

    private Set<String> associateRequirements(Set<Issue> issues, String epicLinkId, JiraRemoteSynchronisation remoteSynchronization, JiraClient jiraClient) {
        HashMap<Long, List<Long>> requirementsToAssociateMap = new HashMap<Long, List<Long>>();
        Set<String> associatedKeys = this.searchKeysNeedToBeAssociate(issues, epicLinkId, remoteSynchronization, jiraClient, requirementsToAssociateMap);
        requirementsToAssociateMap.forEach((highLevelRequirementId, requirementIds) -> this.highLevelRequirementService.bindRequirementsToHighLevelRequirement(highLevelRequirementId, requirementIds, new HighLevelRequirementExceptionSummary()));
        return associatedKeys;
    }

    private Set<String> searchKeysNeedToBeAssociate(Set<Issue> issues, String epicLinkId, JiraRemoteSynchronisation remoteSynchronization, JiraClient jiraClient, Map<Long, List<Long>> requirementsToAssociateMap) {
        HashSet<String> associatedKeys = new HashSet<String>();
        List<String> epicIssueKeys = issues.stream().filter(issue -> EpicIssueType.getAllEpicIssueTypes().contains(issue.getIssueType().getName())).map(BasicIssue::getKey).toList();
        if (!epicIssueKeys.isEmpty()) {
            Map<String, List<String>> jiraIssueKeysByEpicKey = this.getIssuesRelatedToEpicFromJira(issues, epicLinkId, jiraClient, epicIssueKeys);
            this.unlinkOutOfPerimeterSyncRequirements(jiraIssueKeysByEpicKey, remoteSynchronization, epicIssueKeys);
            Set<String> associatedKeysFromEpics = this.searchIssuesLinkedFromEpicsPresentInSynchro(jiraIssueKeysByEpicKey, remoteSynchronization, requirementsToAssociateMap);
            associatedKeys.addAll(associatedKeysFromEpics);
        }
        Set<String> associatedKeysFromIssues = this.searchIssuesLinkedEpicsNotPresentInSynchro(issues, epicIssueKeys, epicLinkId, remoteSynchronization, requirementsToAssociateMap);
        associatedKeys.addAll(associatedKeysFromIssues);
        return associatedKeys;
    }

    private void unlinkOutOfPerimeterSyncRequirements(Map<String, List<String>> jiraIssueKeysByEpicKey, JiraRemoteSynchronisation remoteSynchronization, List<String> epicIssueKeys) {
        Map<String, Map<Long, String>> issueKeyByRequirementIdByEpicKey = this.pluginRequirementDao.getIssueKeyByRequirementIdFromEpicKey(epicIssueKeys, remoteSynchronization.getId());
        if (issueKeyByRequirementIdByEpicKey == null || issueKeyByRequirementIdByEpicKey.isEmpty()) {
            return;
        }
        epicIssueKeys.forEach(epicKey -> {
            Map issueKeyByRequirementId = (Map)issueKeyByRequirementIdByEpicKey.get(epicKey);
            if (issueKeyByRequirementId == null || issueKeyByRequirementId.isEmpty()) {
                return;
            }
            if (jiraIssueKeysByEpicKey.containsKey(epicKey)) {
                List squashIssueKeys = issueKeyByRequirementId.values().stream().toList();
                List jiraIssueKeys = (List)jiraIssueKeysByEpicKey.get(epicKey);
                List<String> keysToUnlink = squashIssueKeys.stream().filter(key -> !jiraIssueKeys.contains(key)).toList();
                issueKeyByRequirementId.forEach((requirementId, key) -> {
                    if (keysToUnlink.contains(key)) {
                        this.highLevelRequirementService.unlinkToHighLevelRequirement(requirementId);
                    }
                });
            } else {
                issueKeyByRequirementId.forEach((requirementId, key) -> this.highLevelRequirementService.unlinkToHighLevelRequirement(requirementId));
            }
        });
    }

    private Map<String, List<String>> getIssuesRelatedToEpicFromJira(Set<Issue> issues, String epicLinkId, JiraClient jiraClient, List<String> epicIssueKeys) {
        String epicLinkName = this.extractEpicLinkNameFromIssues(epicLinkId, issues);
        return this.getJiraIssueKeysByEpic(jiraClient, epicIssueKeys, epicLinkName);
    }

    private String extractEpicLinkNameFromIssues(String epicLinkId, Set<Issue> issues) {
        Optional issue = issues.stream().findFirst();
        if (issue.isPresent()) {
            IssueField epicLinkField = ((Issue)issue.get()).getField(epicLinkId);
            return Objects.isNull(epicLinkField) ? null : epicLinkField.getName();
        }
        throw new IllegalArgumentException("The issue list is empty");
    }

    private Set<String> searchIssuesLinkedFromEpicsPresentInSynchro(Map<String, List<String>> allJiraLinkedIssuesByEpicMap, JiraRemoteSynchronisation remoteSynchronization, Map<Long, List<Long>> result) {
        HashSet<String> linkedEpicKeys = new HashSet<String>();
        allJiraLinkedIssuesByEpicMap.forEach((epicKey, jiraIssues) -> this.appendJiraIssuesForRequirementLinks((List<String>)jiraIssues, (String)epicKey, remoteSynchronization, result, (Set<String>)linkedEpicKeys));
        return linkedEpicKeys;
    }

    private Map<String, List<String>> getJiraIssueKeysByEpic(JiraClient jiraClient, List<String> epicKeys, String epicLinkName) {
        HashMap<String, List<String>> epicAllLinkedIssuesMap = new HashMap<String, List<String>>();
        epicKeys.forEach(epicKey -> {
            List<String> linkedIssues = jiraClient.getLinkedIssuesByEpicKey((String)epicKey, epicLinkName);
            if (!linkedIssues.isEmpty()) {
                epicAllLinkedIssuesMap.put((String)epicKey, linkedIssues);
            }
        });
        return epicAllLinkedIssuesMap;
    }

    private void appendJiraIssuesForRequirementLinks(List<String> allLinkedIssueKeysFromJira, String epicKey, JiraRemoteSynchronisation remoteSynchronization, Map<Long, List<Long>> result, Set<String> associatedKeys) {
        Long currentProjectId = remoteSynchronization.getProject().getId();
        Long remoteSynchronizationId = remoteSynchronization.getId();
        List<SquashIssueLink> issuesPresentOnSquash = this.pluginRequirementDao.searchLinkedIssuesInSquashSynchros(epicKey, remoteSynchronizationId, allLinkedIssueKeysFromJira);
        Long highLevelRequirementId = this.pluginRequirementDao.getHighLevelRequirementIdByJiraEpicKey(epicKey, remoteSynchronizationId);
        if (Objects.nonNull(highLevelRequirementId)) {
            List<SquashIssueLink> linkableIssueLinks = this.filterLinkableIssues(issuesPresentOnSquash, currentProjectId, highLevelRequirementId, epicKey, remoteSynchronizationId);
            if (!linkableIssueLinks.isEmpty()) {
                result.put(highLevelRequirementId, linkableIssueLinks.stream().map(SquashIssueLink::getRequirementId).toList());
            }
            List<String> linkableIssueKeys = linkableIssueLinks.stream().map(SquashIssueLink::getJiraKey).toList();
            associatedKeys.addAll(linkableIssueKeys);
        }
    }

    private List<SquashIssueLink> filterLinkableIssues(List<SquashIssueLink> squashIssueLinks, Long currentProjectId, Long highLevelRequirementId, String epicKey, Long remoteSynchronizationId) {
        return squashIssueLinks.stream().filter(link -> this.isLinkableIssue(currentProjectId, (SquashIssueLink)link, highLevelRequirementId, epicKey, remoteSynchronizationId)).toList();
    }

    private boolean isLinkableIssue(Long currentProjectId, SquashIssueLink link, Long epicHighLevelRequirementId, String epicKey, Long currentSynchronizationId) {
        boolean isNotLinkedToHighLevelRequirement;
        Long associatedHighLevelRequirementId = link.getHighLevelRequirementId();
        boolean bl = isNotLinkedToHighLevelRequirement = !Objects.nonNull(associatedHighLevelRequirementId);
        if (!this.isEpicPresentInSquashLinkSynchro(epicKey, link.getRemoteSynchronisationId(), currentSynchronizationId)) {
            if (isNotLinkedToHighLevelRequirement) {
                return this.hasPermissions(currentProjectId, link);
            }
            if (this.hasEpicLinkUpdated(epicHighLevelRequirementId, associatedHighLevelRequirementId, epicKey)) {
                this.highLevelRequirementService.unlinkToHighLevelRequirement(link.getRequirementId());
                return true;
            }
        }
        return false;
    }

    private boolean hasPermissions(Long currentProjectId, SquashIssueLink link) {
        if (!link.getProjectId().equals(currentProjectId)) {
            return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "READ", link.getProjectId(), GenericProject.class.getName());
        }
        return true;
    }

    private boolean isEpicPresentInSquashLinkSynchro(String epicKey, Long linkSynchronisationId, Long currentSynchronizationId) {
        if (!currentSynchronizationId.equals(linkSynchronisationId)) {
            return this.pluginRequirementDao.isEpicKeyPresentInSynchro(epicKey, linkSynchronisationId);
        }
        return false;
    }

    private boolean hasEpicLinkUpdated(Long epicHighLevelRequirementId, Long associatedHighLevelRequirementId, String epicKey) {
        if (!associatedHighLevelRequirementId.equals(epicHighLevelRequirementId)) {
            return !epicKey.equals(this.pluginRequirementDao.getEpicKeyByHighLevelId(associatedHighLevelRequirementId));
        }
        return false;
    }

    private Set<String> searchIssuesLinkedEpicsNotPresentInSynchro(Set<Issue> issues, List<String> epicKeysPresentInCurrentSynchro, String epicLinkId, JiraRemoteSynchronisation synchronization, Map<Long, List<Long>> requirementIdsToLinkByHighLevelMap) {
        List<Issue> issuesLinkedEpicsAbsentInSynchro = issues.stream().filter(issue -> this.isLinkedToEpicNotInCurrentSynchro((Issue)issue, epicKeysPresentInCurrentSynchro, epicLinkId)).toList();
        HashSet<String> associatedKeys = new HashSet<String>();
        issuesLinkedEpicsAbsentInSynchro.forEach(issue -> this.appendLinkableRequirements(epicLinkId, synchronization, requirementIdsToLinkByHighLevelMap, (Set<String>)associatedKeys, (Issue)issue));
        return associatedKeys;
    }

    private void appendLinkableRequirements(String epicLinkId, JiraRemoteSynchronisation synchronization, Map<Long, List<Long>> requirementIdsToLinkByHighLevelMap, Set<String> associatedKeys, Issue issue) {
        String epicKey = this.extractEpicKeyFromIssue(issue, epicLinkId);
        Long requirementId = this.pluginRequirementDao.getRequirementIdByJiraKeyAndServerId(issue.getKey(), synchronization.getId());
        this.checkEpicHasUpdated(synchronization, issue, epicKey, requirementId);
        this.pluginRequirementDao.appendHighLevelRequirementIfExist(issue.getKey(), requirementIdsToLinkByHighLevelMap, epicKey, synchronization, associatedKeys, requirementId);
    }

    private void checkEpicHasUpdated(JiraRemoteSynchronisation synchronization, Issue issue, String epicKey, Long requirementId) {
        String linkedHighLevelKey;
        boolean isLinkToHighLevel = this.pluginRequirementDao.isRequirementLinkedHighLevel(issue.getKey(), synchronization.getId());
        if (isLinkToHighLevel && !epicKey.equals(linkedHighLevelKey = this.pluginRequirementDao.getHighLevelKeyByRequirementId(requirementId))) {
            this.highLevelRequirementService.unlinkToHighLevelRequirement(requirementId);
        }
    }

    private boolean isLinkedToEpicNotInCurrentSynchro(Issue issue, List<String> epicKeysPresentInCurrentSynchro, String epicLinkId) {
        if (!issue.getIssueType().isSubtask()) {
            IssueField epicField = issue.getField(epicLinkId);
            if (this.isValueFieldExist(epicField)) {
                return !epicKeysPresentInCurrentSynchro.contains(epicField.getValue());
            }
            IssueField parentField = issue.getField(PARENT_FIELD);
            if (this.isValueFieldExist(parentField)) {
                return !epicKeysPresentInCurrentSynchro.contains(this.extractEpicKeyFromParent(issue));
            }
        }
        return false;
    }

    private boolean isValueFieldExist(IssueField field) {
        return Objects.nonNull(field) && Objects.nonNull(field.getValue());
    }

    private String extractEpicKeyFromIssue(Issue issue, String epicLinkId) {
        if (Objects.nonNull(issue.getField(epicLinkId)) && Objects.nonNull(issue.getField(epicLinkId).getValue())) {
            return (String)issue.getField(epicLinkId).getValue();
        }
        return this.extractEpicKeyFromParent(issue);
    }

    private String extractEpicKeyFromParent(Issue issue) {
        IssueField field = issue.getField(PARENT_FIELD);
        JSONObject jsonParent = (JSONObject)field.getValue();
        return jsonParent.optString("key");
    }

    private void processSubTaskRelationship(JiraRemoteSynchronisation jiraRemoteSynchronisation, ArrayList<String> allKeys) {
        Map<Long, List<String>> subTasksToMove = this.pluginRequirementDao.findSubtaskToMove(jiraRemoteSynchronisation.getId(), new HashSet<String>(allKeys));
        List<String> keys = subTasksToMove.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).toList();
        Map<String, Long> eligibleToBeMoved = this.pluginRequirementDao.findReqIdAndJiraKeyInSynchronizedFolder(jiraRemoteSynchronisation.getId(), keys, jiraRemoteSynchronisation.getTargetFolderId());
        subTasksToMove.forEach((parentId, subtasksKeys) -> {
            HashSet requirementToMove = new HashSet();
            subtasksKeys.forEach(subtaskKey -> {
                if (eligibleToBeMoved.containsKey(subtaskKey)) {
                    requirementToMove.add((Long)eligibleToBeMoved.get(subtaskKey));
                }
            });
            if (!requirementToMove.isEmpty()) {
                this.requirementLibraryNavigationService.moveNodesToRequirement(parentId.longValue(), requirementToMove.toArray(new Long[requirementToMove.size()]));
            }
        });
    }

    private Long validateSynchronisationTargetFolder(JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        boolean nodeExists;
        Long targetFolderId = this.pluginRequirementDao.findTargetFolderId(jiraRemoteSynchronisation.getRemoteSynchronisation().getId());
        if (targetFolderId != null) {
            return targetFolderId;
        }
        String path = jiraRemoteSynchronisation.getSynchronisationPath();
        boolean bl = nodeExists = !Objects.isNull(this.libraryNodeDao.findNodeIdByPath(path));
        if (!nodeExists) {
            Long folderId = this.requirementLibraryNavigationService.mkdirs(path);
            RequirementFolder requirementFolder = (RequirementFolder)this.entityManager.find(RequirementFolder.class, (Object)folderId);
            RequirementFolderSyncExtender syncExtender = new RequirementFolderSyncExtender();
            syncExtender.setRequirementFolder(requirementFolder);
            syncExtender.setType(RequirementFolderSyncExtenderType.TARGET);
            syncExtender.setRemoteSynchronisation(jiraRemoteSynchronisation.getRemoteSynchronisation());
            this.entityManager.persist((Object)syncExtender);
            return folderId;
        }
        throw new IllegalArgumentException("The path " + path + " is not a valid target for synchronisation " + String.valueOf(jiraRemoteSynchronisation) + ". Aborting");
    }

    private Long validateTargetSprintGroup(JiraRemoteSynchronisation jiraRemoteSynchronisation) {
        Long remoteSyncId = jiraRemoteSynchronisation.getId();
        Long targetSprintGroupId = this.sprintGroupDao.findIdByProjectIdAndRemoteSynchronisationId(jiraRemoteSynchronisation.getProject().getId(), remoteSyncId);
        if (Objects.nonNull(targetSprintGroupId)) {
            return targetSprintGroupId;
        }
        targetSprintGroupId = this.campaignLibraryNavigationService.createSprintGroupAndFoldersHierarchy(jiraRemoteSynchronisation.getSprintSynchronisationPath());
        this.sprintGroupDao.updateRemoteSyncId(targetSprintGroupId, remoteSyncId);
        return targetSprintGroupId;
    }

    private RemoteRequirementKeys findDesynchronisedIssueKeys(JiraRemoteSynchronisation jiraRemoteSynchronisation, JiraClient jiraClient) {
        RemoteRequirementFinder remoteRequirementFinder = this.remoteRequirementFinderFactory.create(jiraRemoteSynchronisation, jiraClient);
        return remoteRequirementFinder.findRemoteRequirementKeys();
    }

    private JiraRequirementImporter createImporter(Long serverId, Long projectId, SynchronisationEffectiveConfiguration effective) {
        Project project = (Project)this.projectDao.getReferenceById((Object)projectId);
        BugTracker server = this.serverService.findById(serverId.longValue());
        JiraRequirementImporter importer = (JiraRequirementImporter)this.importerProvider.get();
        importer.setServer(server);
        importer.setProject(project);
        importer.setConfiguration(effective);
        importer.configure();
        return importer;
    }

    private Map<Issue, RequirementVersionInstruction> getSquashRequirements(List<Map<Issue, RequirementVersionInstruction>> squashReqs) {
        HashMap<Issue, RequirementVersionInstruction> oneMap = new HashMap<Issue, RequirementVersionInstruction>();
        if (squashReqs.size() == 1) {
            return squashReqs.get(0);
        }
        for (Map<Issue, RequirementVersionInstruction> mapped : squashReqs) {
            oneMap.putAll(mapped);
        }
        return oneMap;
    }

    private void associateLinksToSquashReqs(JiraClient client, Map<Issue, RequirementVersionInstruction> squashReqs, SynchronisationEffectiveConfiguration conf, List<FieldLink> fieldLinks, Long synchronizationId) {
        List<String> closedStatus = this.getClosedStatus(conf);
        for (Map.Entry<Issue, RequirementVersionInstruction> entry : squashReqs.entrySet()) {
            RequirementVersionInstruction instruction = entry.getValue();
            List<String> linkedJiraKeys = this.createAllLinks(entry.getKey(), fieldLinks, closedStatus, client, squashReqs, synchronizationId);
            this.deleteLinksNotInJira(instruction, linkedJiraKeys, synchronizationId);
        }
        this.relKeys.clear();
    }

    private List<String> getClosedStatus(SynchronisationEffectiveConfiguration conf) {
        ArrayList<String> closedStatus = new ArrayList<String>();
        ValueMappings valueMappings = conf.getValueMappings();
        if (!valueMappings.isEmpty() && valueMappings.get(STATUS) != null) {
            Map statutes = (Map)valueMappings.get(STATUS);
            for (Map.Entry status : statutes.entrySet()) {
                if (!"obsolete".equals(status.getValue())) continue;
                closedStatus.add((String)status.getKey());
            }
        }
        return closedStatus;
    }

    private List<FieldLink> getConfiguredFieldLinks(Long projectId) {
        Configuration config = this.pluginRequirementDao.getConfigurationForProject(projectId);
        List<FieldLink> fieldLinks = config.getFieldLinks();
        return fieldLinks.stream().filter(fieldLink -> fieldLink.getJiraField() != null && !fieldLink.getJiraField().isEmpty()).toList();
    }

    private void deleteLinksNotInJira(RequirementVersionInstruction instruction, List<String> linkedJiraKeys, Long synchronizationId) {
        if (instruction.getMode().equals((Object)ImportMode.UPDATE)) {
            this.pluginRequirementDao.deleteLinkedRequirementVersion(instruction.getRequirementVersion().getId(), linkedJiraKeys, synchronizationId);
        }
    }

    private List<String> createAllLinks(Issue issue, List<FieldLink> fieldLinksMap, List<String> closedStatus, JiraClient client, Map<Issue, RequirementVersionInstruction> squashReqs, Long synchronizationId) {
        ArrayList<String> issueKeysLinked = new ArrayList<String>();
        Iterable<IssueLink> issueLinkIterable = client.getIssueLinksByIssueKey(issue.getKey());
        if (issueLinkIterable != null) {
            Iterator<IssueLink> issueLinkIterator = issueLinkIterable.iterator();
            issueLinkIterator.forEachRemaining(issueLink -> {
                for (FieldLink fieldLink : fieldLinksMap) {
                    if (!fieldLink.getJiraField().equals(issueLink.getIssueLinkType().getName())) continue;
                    issueKeysLinked.add(this.createLink((IssueLink)issueLink, fieldLink, issue, squashReqs, client, closedStatus, synchronizationId));
                    break;
                }
            });
        }
        return issueKeysLinked;
    }

    private String createLink(IssueLink issueLink, FieldLink fieldLink, Issue issue, Map<Issue, RequirementVersionInstruction> squashReqs, JiraClient client, List<String> closedStatus, Long synchronizationId) {
        boolean linksAlreadyCreated;
        Issue targetIssue = client.getIssueByIssueKey(issueLink.getTargetIssueKey());
        boolean hasClosedStatus = closedStatus.contains(issue.getStatus().toString()) || closedStatus.contains(targetIssue.getStatus().toString());
        boolean bl = linksAlreadyCreated = targetIssue.getKey().equals(this.relKeys.get(issue.getKey())) || issue.getKey().equals(this.relKeys.get(targetIssue.getKey()));
        if (!hasClosedStatus && !linksAlreadyCreated) {
            if (squashReqs.containsKey(targetIssue)) {
                String role = this.determineRole(issueLink, fieldLink);
                this.linkedRequirementVersionManagerService.addOrUpdateRequirementLink(squashReqs.get(issue).getRequirementVersion().getId(), squashReqs.get(targetIssue).getRequirementVersion().getId(), role);
                this.relKeys.put(issue.getKey(), targetIssue.getKey());
                this.relKeys.put(targetIssue.getKey(), issue.getKey());
            } else {
                RequirementSyncExtender targetIssueSyncExtender = this.requirementSyncExtenderDao.retrieveByRemoteKeyAndSyncId(targetIssue.getKey(), synchronizationId);
                if (targetIssueSyncExtender != null) {
                    String role = this.determineRole(issueLink, fieldLink);
                    this.linkedRequirementVersionManagerService.addOrUpdateRequirementLink(squashReqs.get(issue).getRequirementVersion().getId(), targetIssueSyncExtender.getRequirement().getCurrentVersion().getId(), role);
                    this.relKeys.put(issue.getKey(), targetIssue.getKey());
                    this.relKeys.put(targetIssue.getKey(), issue.getKey());
                }
            }
        }
        return issueLink.getTargetIssueKey();
    }

    private String determineRole(IssueLink issueLink, FieldLink fieldLink) {
        boolean isInbound = issueLink.getIssueLinkType().getDirection().equals((Object)IssueLinkType.Direction.INBOUND);
        RequirementVersionLinkType link = (RequirementVersionLinkType)this.requirementVersionLinkTypeDao.findById((Object)fieldLink.getSquashLinkTypeId()).get();
        String role = isInbound ? link.getRole1Code() : link.getRole2Code();
        return role;
    }

    public void checkIfMaxNumberOfIssuesInPerimeterExceeded(JiraRemoteSynchronisation synchronisation, boolean isSprintSynchro) {
        RemoteRequirementFinder remoteRequirementFinder = this.remoteRequirementFinderFactory.create(synchronisation, this.getJiraClient(synchronisation));
        remoteRequirementFinder.checkIfMaxNumberOfIssuesInPerimeterExceeded(isSprintSynchro);
    }
}

