/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.helpers;

import jakarta.inject.Inject;
import java.text.ParseException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.jirasync.helpers.JiraValue;
import org.squashtest.tm.plugin.jirasync.helpers.TechnicalDataDictionary;
import org.squashtest.tm.plugin.jirasync.service.ValueMappings;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;

@Component(value="squash.tm.plugin.jirasync.squashHelper")
@Scope(value="prototype")
public class SquashHelper {
    private static final String BR_TAG = "<br/>";
    private static final int DATE_CHAR_LEN = "yyyy-MM-dd".length();
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashHelper.class);
    @Inject
    private TechnicalDataDictionary dictionary;

    public void initForProject(Project p, ValueMappings valueMappings) {
        this.dictionary.initForProject(p, valueMappings);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.dictionary.toString());
        }
    }

    public void setBuiltinProperty(RequirementVersion version, BuiltinSquashField builtinSquashField, JiraValue jiraValue) {
        RequirementVersion.PropertiesSetter setter = version.getPropertySetter();
        switch (builtinSquashField) {
            case CATEGORY: {
                setter.setCategory((InfoListItem)this.asCategory(jiraValue));
                break;
            }
            case CREATED_BY: {
                setter.setCreatedBy(jiraValue.getFirst());
                break;
            }
            case CREATED_ON: {
                setter.setCreatedOn(this.asDate(jiraValue));
                break;
            }
            case CRITICALITY: {
                RequirementCriticality crit = this.asCriticality(jiraValue);
                setter.setCriticality(crit);
                break;
            }
            case DESCRIPTION: {
                setter.setDescription(ExcelRowReaderUtils.escapeHTMLInsideTags((String)jiraValue.getValues("</br>").replace("\n", "</br>")));
                break;
            }
            case LABEL: {
                setter.setName(jiraValue.getValues(";"));
                break;
            }
            case MODIFIED_BY: {
                setter.setLastModifiedBy(jiraValue.getFirst());
                break;
            }
            case MODIFIED_ON: {
                setter.setLastModifiedOn(this.asDate(jiraValue));
                break;
            }
            case REFERENCE: {
                setter.setReference(jiraValue.getFirst());
                break;
            }
            case STATUS: {
                setter.setStatus(this.asStatus(jiraValue));
            }
        }
    }

    public String getCustomfieldValue(String squashCuf, JiraValue jiraValue) {
        InputType type = this.dictionary.lookupCufType(squashCuf);
        String res = null;
        switch (type) {
            case CHECKBOX: {
                res = this.asBoolean(jiraValue);
                break;
            }
            case DATE_PICKER: {
                res = this.asStringDate(jiraValue);
                break;
            }
            case DROPDOWN_LIST: {
                String label = jiraValue.getFirst() != null ? jiraValue.getFirst() : "";
                res = this.dictionary.lookupItemCode(squashCuf, label);
                break;
            }
            case PLAIN_TEXT: {
                res = jiraValue.getValues(";");
                break;
            }
            case RICH_TEXT: {
                res = HTMLSanitizeUtils.cleanHtml((String)jiraValue.getValues(BR_TAG).replace("\n", BR_TAG));
                break;
            }
            case TAG: {
                res = jiraValue.getValues("|");
                break;
            }
            case NUMERIC: {
                res = jiraValue.getFirst();
                break;
            }
            default: {
                throw new IllegalArgumentException("custom field of type '" + type.toString() + "' are not implemented here");
            }
        }
        return res;
    }

    private ListItemReference asCategory(JiraValue jvalue) {
        String value = jvalue.getFirst();
        ListItemReference cat = this.dictionary.lookupCategory(value);
        if (cat != null) {
            return cat;
        }
        throw new IllegalArgumentException("cannot find an category that match value '" + value + "' by label or code");
    }

    private Date asDate(JiraValue jvalue) {
        String value = jvalue.getFirst();
        try {
            return DateUtils.parseIso8601DateTime((String)value);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("cannot parse '" + value + "' as a date");
        }
    }

    private String asStringDate(JiraValue jvalue) {
        String value = jvalue.getFirst();
        if (value == null) {
            return null;
        }
        return value.substring(0, DATE_CHAR_LEN);
    }

    private RequirementCriticality asCriticality(JiraValue jvalue) {
        String value = jvalue.getFirst();
        RequirementCriticality crit = this.dictionary.lookupCriticity(value);
        if (crit != null) {
            return crit;
        }
        throw new IllegalArgumentException("cannot find a criticality that match value '" + value + "' by label or code");
    }

    private RequirementStatus asStatus(JiraValue jvalue) {
        String value = jvalue.getFirst();
        RequirementStatus status = this.dictionary.lookupStatus(value);
        if (status != null) {
            return status;
        }
        throw new IllegalArgumentException("cannot find a status that match value '" + value + "' by label or code");
    }

    private String asBoolean(JiraValue jvalue) {
        String val = jvalue.getFirst();
        String value = this.dictionary.lookupBoolean(val);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("cannot find a boolean that match value '" + val + "'");
    }
}

