/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.api.widget.InternationalizedMenuItem;
import org.squashtest.tm.api.widget.MenuItem;
import org.squashtest.tm.api.widget.TreeNodeType;
import org.squashtest.tm.api.widget.access.AccessRuleBuilder;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.jirasync.JIRASyncPlugin;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.jirasync.service.RequirementSynchronizationService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Configuration(value="squash.tm.plugin.jirasync.conf")
@ComponentScan(basePackages={"org.squashtest.tm.plugin.jirasync"})
public class SpringConfig {
    @Inject
    private RequirementSynchronizationService requirementSynchronizationService;
    @Inject
    private InternationalizationHelper langHelper;
    @Inject
    private ConfigurationService configurationService;

    @Bean(name={"squash.tm.plugin.jirasync"})
    public JIRASyncPlugin jiraReqPlugin() {
        JIRASyncPlugin plugin = new JIRASyncPlugin();
        plugin.setRequirementSynchronizationService(this.requirementSynchronizationService);
        plugin.setConfigurationService(this.configurationService);
        plugin.setBeanName("squash.tm.plugin.jirasync");
        plugin.setNameKey("henix.jirasync.plugin.name");
        plugin.setTypeKey("henix.jirasync.plugin.type");
        plugin.setDisplayWorkspace(WorkspaceType.CAMPAIGN_WORKSPACE);
        plugin.setWizardMenu(this.wizardItem());
        return plugin;
    }

    private MenuItem wizardItem() {
        InternationalizedMenuItem item = new InternationalizedMenuItem();
        item.setUrl("plugin/jirasync/campaign-wizard");
        item.setAccessRule(AccessRuleBuilder.singleNodeSelection().nodePermission(TreeNodeType.CAMPAIGN, Permissions.WRITE).or().nodePermission(TreeNodeType.ITERATION, Permissions.WRITE).build());
        item.setTooltipKey("henix.jirasync.execplan.menu.tooltip");
        item.setLabelKey("henix.jirasync.execplan.menu.label");
        item.setMessageSource((MessageSource)this.langHelper);
        item.afterPropertiesSet();
        return item;
    }

    @Bean(name={"squash.tm.plugin.jirasync.mappings.valuefinders"})
    public Properties valuefindersMapping() throws IOException {
        return this.loadMapping("org/squashtest/tm/plugin/jirasync/jira-json-valuefinders.properties");
    }

    @Bean(name={"squash.tm.plugin.jirasync.mappings.parsers"})
    public Properties parsersMapping() throws IOException {
        return this.loadMapping("org/squashtest/tm/plugin/jirasync/jira-cf-parsers-mapping.properties");
    }

    @Bean(name={"squash.tm.plugin.jirasync.mappings.domain"})
    public Properties domainMapping() throws IOException {
        return this.loadMapping("org/squashtest/tm/plugin/jirasync/jira-cf-domain-mapping.properties");
    }

    private Properties loadMapping(String pptFile) throws IOException {
        try (InputStream pstream = null;){
            Properties properties = new Properties();
            ClassLoader cl = SpringConfig.class.getClassLoader();
            pstream = cl.getResourceAsStream(pptFile);
            properties.load(pstream);
            Properties properties2 = properties;
            return properties2;
        }
    }
}

