/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json.gen;

import jirasync.com.atlassian.jira.rest.client.api.RestClientException;
import jirasync.com.atlassian.jira.rest.client.api.domain.AssigneeType;
import jirasync.com.atlassian.jira.rest.client.internal.domain.input.ComponentInputWithProjectKey;
import jirasync.com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class ComponentInputWithProjectKeyJsonGenerator
implements JsonGenerator<ComponentInputWithProjectKey> {
    @Override
    public JSONObject generate(ComponentInputWithProjectKey componentInput) throws JSONException {
        AssigneeType assigneeType;
        JSONObject res = new JSONObject();
        if (componentInput.getProjectKey() != null) {
            res.put("project", componentInput.getProjectKey());
        }
        if (componentInput.getName() != null) {
            res.put("name", componentInput.getName());
        }
        if (componentInput.getDescription() != null) {
            res.put("description", componentInput.getDescription());
        }
        if (componentInput.getLeadUsername() != null) {
            res.put("leadUserName", componentInput.getLeadUsername());
        }
        if ((assigneeType = componentInput.getAssigneeType()) != null) {
            String assigneeTypeStr;
            switch (assigneeType) {
                case PROJECT_DEFAULT: {
                    assigneeTypeStr = "PROJECT_DEFAULT";
                    break;
                }
                case COMPONENT_LEAD: {
                    assigneeTypeStr = "COMPONENT_LEAD";
                    break;
                }
                case PROJECT_LEAD: {
                    assigneeTypeStr = "PROJECT_LEAD";
                    break;
                }
                case UNASSIGNED: {
                    assigneeTypeStr = "UNASSIGNED";
                    break;
                }
                default: {
                    throw new RestClientException("Unexpected assignee type [" + (Object)((Object)assigneeType) + "]", null);
                }
            }
            res.put("assigneeType", assigneeTypeStr);
        }
        return res;
    }
}

