/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.json;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import jirasync.com.atlassian.jira.rest.client.api.domain.BulkOperationErrorResult;
import jirasync.com.atlassian.jira.rest.client.api.domain.util.ErrorCollection;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirasync.org.codehaus.jettison.json.JSONArray;
import jirasync.org.codehaus.jettison.json.JSONException;
import jirasync.org.codehaus.jettison.json.JSONObject;

public class IssueErrorJsonParser
implements JsonObjectParser<BulkOperationErrorResult> {
    @Override
    public BulkOperationErrorResult parse(JSONObject json) throws JSONException {
        Integer status = json.getInt("status");
        Integer issueNumber = json.getInt("failedElementNumber");
        JSONObject elementErrors = json.optJSONObject("elementErrors");
        JSONObject jsonErrors = elementErrors.optJSONObject("errors");
        JSONArray jsonErrorMessages = elementErrors.optJSONArray("errorMessages");
        Collection<Object> errorMessages = jsonErrorMessages != null ? JsonParseUtil.toStringCollection(jsonErrorMessages) : Collections.emptyList();
        Map<String, String> errors = jsonErrors != null ? JsonParseUtil.toStringMap(jsonErrors.names(), jsonErrors) : Collections.emptyMap();
        return new BulkOperationErrorResult(new ErrorCollection(status, errorMessages, errors), issueNumber);
    }
}

