/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsBugTrackerAndPath;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsCachedValues;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsCompositeCacheKey;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClient;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClientFactory;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

public class AzureDevopsValueCacheWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureDevopsValueCacheWorker.class);
    private final AzureDevopsValueCacheManager manager;
    private final AzureDevOpsClientFactory azureDevOpsClientFactory;
    private final int id;
    private final Object lock = new Object();

    AzureDevopsValueCacheWorker(AzureDevopsValueCacheManager azureDevopsValueCacheManager, AzureDevOpsClientFactory azureDevOpsClientFactory, int id) {
        this.manager = azureDevopsValueCacheManager;
        this.azureDevOpsClientFactory = azureDevOpsClientFactory;
        this.id = id;
    }

    public void start() {
        this.manager.getTaskScheduler().schedule(this::processInSynchronizedBlock, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInSynchronizedBlock() {
        Object object = this.lock;
        synchronized (object) {
            this.doProcess();
        }
    }

    private void doProcess() {
        while (!this.manager.getQueue().isEmpty()) {
            AzureDevopsBugTrackerAndPath azureDevopsBugTrackerAndPath = this.manager.getQueue().poll();
            String projectPath = azureDevopsBugTrackerAndPath.path();
            Credentials credentials = this.findCredentials(azureDevopsBugTrackerAndPath.bugTracker());
            if (credentials == null) {
                LOGGER.warn("[Worker #{}] No credentials found for bugtracker {}. Cache cannot be used", (Object)this.id, (Object)azureDevopsBugTrackerAndPath.bugTracker().getId());
                continue;
            }
            this.updateCachedValues(azureDevopsBugTrackerAndPath.bugTracker(), projectPath, credentials);
        }
    }

    private void updateCachedValues(BugTracker bugTracker, String projectPath, Credentials credentials) {
        LOGGER.trace("[Worker #{}] Updating cache for project {} and bug tracker {}", new Object[]{this.id, projectPath, bugTracker.getId()});
        AzureDevOpsClient client = this.createAzureClient(bugTracker, credentials);
        AzureDevopsCompositeCacheKey key = new AzureDevopsCompositeCacheKey(bugTracker.getId(), projectPath);
        try {
            AzureDevopsCachedValues azureDevopsCachedValues = AzureDevopsCachedValues.of(this.manager.getTeamMembersPool().replaceWithReferencesForSet(bugTracker.getId(), client.findTeamMembers(projectPath, client.getTeams(projectPath))), this.manager.getTagsPool().replaceWithReferences(bugTracker.getId(), client.findAllTags(projectPath)), client.getProjectAreas(projectPath), client.getProjectIterations(projectPath));
            this.manager.cacheMap.put(key, azureDevopsCachedValues);
            LOGGER.trace("[Worker #{}] Finished cache update for project {} and bug tracker {}", new Object[]{this.id, projectPath, bugTracker.getId()});
        }
        catch (HttpClientErrorException exception) {
            if (this.manager.cacheMap.containsKey(key)) {
                this.manager.cacheMap.put(key, this.manager.cacheMap.get(key).withLastUpdateError());
            } else {
                this.manager.cacheMap.put(key, AzureDevopsCachedValues.error());
            }
            Object message = "[Worker #%s] Error while updating cache for project %s and bug tracker %s.".formatted(this.id, projectPath, bugTracker.getId());
            if (this.manager.cacheMap.get(key).hasCachedValues()) {
                message = (String)message + " The previously cached will be used until the next update.";
            }
            LOGGER.error((String)message, (Throwable)exception);
        }
    }

    public AzureDevOpsClient createAzureClient(BugTracker bugTracker, Credentials credentials) {
        AzureDevOpsClient client = this.azureDevOpsClientFactory.createClient();
        client.init(bugTracker, credentials);
        return client;
    }

    private Credentials findCredentials(BugTracker bugTracker) {
        StoredCredentialsManager storedCredentialsManager = this.manager.getStoredCredentialsManager();
        ManageableCredentials manageableCredentials = storedCredentialsManager.findReportingCacheCredentials(bugTracker.getId().longValue());
        if (manageableCredentials == null) {
            return null;
        }
        return manageableCredentials.build(storedCredentialsManager, (ThirdPartyServer)bugTracker, null);
    }
}

