/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.oslc4j.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.CreationFactory;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Dialog;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Occurs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.QueryCapability;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Representation;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Service Resource Shape", describes={"http://open-services.net/ns/core#Service"})
public class Service
extends AbstractResource {
    private final List<Dialog> creationDialogs = new ArrayList<Dialog>();
    private final List<CreationFactory> creationFactories = new ArrayList<CreationFactory>();
    private final List<QueryCapability> queryCapabilities = new ArrayList<QueryCapability>();
    private final List<Dialog> selectionDialogs = new ArrayList<Dialog>();
    private final List<URI> usages = new ArrayList<URI>();
    private URI domain;

    public Service() {
    }

    public Service(URI domain) {
        this();
        this.domain = domain;
    }

    public void addCreationDialog(Dialog dialog) {
        this.creationDialogs.add(dialog);
    }

    public void addCreationFactory(CreationFactory creationFactory) {
        this.creationFactories.add(creationFactory);
    }

    public void addQueryCapability(QueryCapability queryCapability) {
        this.queryCapabilities.add(queryCapability);
    }

    public void addSelectionDialog(Dialog dialog) {
        this.selectionDialogs.add(dialog);
    }

    @OslcDescription(value="Enables clients to create a resource via UI")
    @OslcName(value="creationDialog")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#creationDialog")
    @OslcRange(value={"http://open-services.net/ns/core#Dialog"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Creation Dialogs")
    @OslcValueShape(value="resourceShapes/dialog")
    @OslcValueType(value=ValueType.LocalResource)
    public Dialog[] getCreationDialogs() {
        return this.creationDialogs.toArray(new Dialog[this.creationDialogs.size()]);
    }

    @OslcDescription(value="Enables clients to create new resources")
    @OslcName(value="creationFactory")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#creationFactory")
    @OslcRange(value={"http://open-services.net/ns/core#CreationFactory"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Creation Factories")
    @OslcValueShape(value="resourceShapes/creationFactory")
    @OslcValueType(value=ValueType.LocalResource)
    public CreationFactory[] getCreationFactories() {
        return this.creationFactories.toArray(new CreationFactory[this.creationFactories.size()]);
    }

    @OslcDescription(value="Namespace URI of the OSLC domain specification that is implemented by this service")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#domain")
    @OslcReadOnly
    @OslcTitle(value="Domain")
    public URI getDomain() {
        return this.domain;
    }

    @OslcDescription(value="Enables clients query across a collection of resources")
    @OslcName(value="queryCapability")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#queryCapability")
    @OslcRange(value={"http://open-services.net/ns/core#QueryCapability"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Query Capabilities")
    @OslcValueShape(value="resourceShapes/queryCapability")
    @OslcValueType(value=ValueType.LocalResource)
    public QueryCapability[] getQueryCapabilities() {
        return this.queryCapabilities.toArray(new QueryCapability[this.queryCapabilities.size()]);
    }

    @OslcDescription(value="Enables clients to select a resource via UI")
    @OslcName(value="selectionDialog")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#selectionDialog")
    @OslcRange(value={"http://open-services.net/ns/core#Dialog"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Selection Dialogs")
    @OslcValueShape(value="resourceShapes/dialog")
    @OslcValueType(value=ValueType.LocalResource)
    public Dialog[] getSelectionDialogs() {
        return this.selectionDialogs.toArray(new Dialog[this.selectionDialogs.size()]);
    }

    @OslcDescription(value="An identifier URI for the domain specified usage of this service")
    @OslcName(value="usage")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#usage")
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Reference)
    @OslcTitle(value="Usages")
    @OslcValueType(value=ValueType.Resource)
    @OslcOccurs(value=Occurs.ZeroOrMany)
    public URI[] getUsages() {
        return this.usages.toArray(new URI[this.usages.size()]);
    }

    public void setCreationDialogs(Dialog[] creationDialogs) {
        this.creationDialogs.clear();
        if (creationDialogs != null) {
            this.creationDialogs.addAll(Arrays.asList(creationDialogs));
        }
    }

    public void setCreationFactories(CreationFactory[] creationFactories) {
        this.creationFactories.clear();
        if (creationFactories != null) {
            this.creationFactories.addAll(Arrays.asList(creationFactories));
        }
    }

    public void setDomain(URI domain) {
        this.domain = domain;
    }

    public void setQueryCapabilities(QueryCapability[] queryCapabilities) {
        this.queryCapabilities.clear();
        if (queryCapabilities != null) {
            this.queryCapabilities.addAll(Arrays.asList(queryCapabilities));
        }
    }

    public void setSelectionDialogs(Dialog[] selectionDialogs) {
        this.selectionDialogs.clear();
        if (selectionDialogs != null) {
            this.selectionDialogs.addAll(Arrays.asList(selectionDialogs));
        }
    }

    public void setUsages(URI[] usages) {
        this.usages.clear();
        if (usages != null) {
            this.usages.addAll(Arrays.asList(usages));
        }
    }
}

