/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Occurs;

@OslcResourceShape(title="Architecture Management LinkType Resource Shape", describes={"http://open-services.net/ns/am#LinkType"})
@OslcNamespace(value="http://open-services.net/ns/am#")
@OslcName(value="LinkType")
public final class ArchitectureLinkType
extends AbstractResource {
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<URI> rdfTypes = new TreeSet<URI>();
    private Date created;
    private String comment;
    private String label;
    private String identifier;
    private URI instanceShape;
    private Date modified;
    private URI serviceProvider;

    public ArchitectureLinkType() {
        this.rdfTypes.add(URI.create("http://open-services.net/ns/am#LinkType"));
    }

    public ArchitectureLinkType(URI about) {
        super(about);
        this.rdfTypes.add(URI.create("http://open-services.net/ns/am#LinkType"));
    }

    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/am#LinkType");
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRdfType(URI rdfType) {
        this.rdfTypes.add(rdfType);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the automation plan.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Timestamp of resource creation.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcReadOnly
    @OslcTitle(value="Created")
    public Date getCreated() {
        return this.created;
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="The human readable name for this link type.")
    @OslcPropertyDefinition(value="http://www.w3.org/2000/01/rdf-schema#label")
    @OslcTitle(value="Label")
    @OslcOccurs(value=Occurs.ExactlyOne)
    public String getLabel() {
        return this.label;
    }

    @OslcDescription(value="Descriptive text about link type. ")
    @OslcPropertyDefinition(value="http://www.w3.org/2000/01/rdf-schema#comment")
    @OslcTitle(value="Comment")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    public String getComment() {
        return this.comment;
    }

    @OslcDescription(value="A unique identifier for a resource. Assigned by the service provider when a resource is created. Not intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcTitle(value="Identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcTitle(value="Instance Shape")
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    @OslcDescription(value="Timestamp last latest resource modification.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcReadOnly
    @OslcTitle(value="Modified")
    public Date getModified() {
        return this.modified;
    }

    @OslcDescription(value="The resource type URIs.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Types")
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcTitle(value="Service Provider")
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    public void setServiceProvider(URI serviceProvider) {
        this.serviceProvider = serviceProvider;
    }
}

