/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.json4j.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import plugin.rtc.org.apache.wink.json4j.JSONArray;
import plugin.rtc.org.apache.wink.json4j.JSONObject;
import plugin.rtc.org.apache.wink.json4j.utils.internal.JSONSAXHandler;

public class XML {
    private static String className = "org.apache.commons.json.xml.transform.XML";
    private static Logger logger = Logger.getLogger(className, null);
    private static final String styleSheet = " <xsl:stylesheet version=\"1.0\"                                   \n     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">           \n   <xsl:output method=\"xml\"/>                                    \n   <xsl:param name=\"indent-increment\" select=\"'   '\" />        \n   <xsl:template match=\"*\">                                      \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"comment()|processing-instruction()\">     \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"text()[normalize-space(.)='']\"/>         \n </xsl:stylesheet>                                                 \n";

    public static void toJson(InputStream XMLStream, OutputStream JSONStream) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toJson(InputStream, OutputStream)");
        }
        XML.toJson(XMLStream, JSONStream, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toJson(InputStream, OutputStream)");
        }
    }

    public static void toJson(InputStream XMLStream, OutputStream JSONStream, boolean verbose) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toJson(InputStream, OutputStream)");
        }
        if (XMLStream == null) {
            throw new NullPointerException("XMLStream cannot be null");
        }
        if (JSONStream == null) {
            throw new NullPointerException("JSONStream cannot be null");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "transform", "Fetching a SAX parser for use with JSONSAXHandler");
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser sParser = factory.newSAXParser();
            XMLReader parser = sParser.getXMLReader();
            JSONSAXHandler jsonHandler = new JSONSAXHandler(JSONStream, verbose);
            parser.setContentHandler(jsonHandler);
            parser.setErrorHandler(jsonHandler);
            InputSource source = new InputSource(new BufferedInputStream(XMLStream));
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "transform", "Parsing the XML content to JSON");
            }
            source.setEncoding("UTF-8");
            parser.parse(source);
            jsonHandler.flushBuffer();
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException("Could not get a parser: " + pce.toString());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, OutputStream)");
        }
    }

    public static String toJson(InputStream xmlStream) throws SAXException, IOException {
        return XML.toJson(xmlStream, false);
    }

    public static String toJson(InputStream xmlStream, boolean verbose) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String result = null;
        try {
            XML.toJson(xmlStream, baos, verbose);
            result = baos.toString("UTF-8");
            baos.close();
        }
        catch (UnsupportedEncodingException uec) {
            IOException iox = new IOException(uec.toString());
            iox.initCause(uec);
            throw iox;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        return result;
    }

    public static String toJson(File xmlFile, boolean verbose) throws SAXException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        FileInputStream fis = new FileInputStream(xmlFile);
        String result = null;
        result = XML.toJson((InputStream)fis, verbose);
        fis.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toJson(InputStream, boolean)");
        }
        return result;
    }

    public static String toJson(File xmlFile) throws SAXException, IOException {
        return XML.toJson(xmlFile, false);
    }

    public static void toXml(InputStream JSONStream, OutputStream XMLStream) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toXml(InputStream, OutputStream)");
        }
        XML.toXml(JSONStream, XMLStream, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toXml(InputStream, OutputStream)");
        }
    }

    public static void toXml(InputStream JSONStream, OutputStream XMLStream, boolean verbose) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "toXml(InputStream, OutputStream)");
        }
        if (XMLStream == null) {
            throw new NullPointerException("XMLStream cannot be null");
        }
        if (JSONStream == null) {
            throw new NullPointerException("JSONStream cannot be null");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, className, "transform", "Parsing the JSON and a DOM builder.");
        }
        try {
            JSONObject jObject = new JSONObject(JSONStream);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            if (logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, className, "transform", "Parsing the JSON content to XML");
            }
            XML.convertJSONObject(doc, doc.getDocumentElement(), jObject, "jsonObject");
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer serializer = null;
            serializer = verbose ? tfactory.newTransformer(new StreamSource(new StringReader(styleSheet))) : tfactory.newTransformer();
            Properties oprops = new Properties();
            oprops.put("method", "xml");
            oprops.put("omit-xml-declaration", "yes");
            oprops.put("version", "1.0");
            oprops.put("indent", "true");
            serializer.setOutputProperties(oprops);
            serializer.transform(new DOMSource(doc), new StreamResult(XMLStream));
        }
        catch (Exception ex) {
            IOException iox = new IOException("Problem during conversion");
            iox.initCause(ex);
            throw iox;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, OutputStream)");
        }
    }

    public static String toXml(InputStream JSONStream) throws IOException {
        return XML.toXml(JSONStream, false);
    }

    public static String toXml(InputStream JSONStream, boolean verbose) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String result = null;
        try {
            XML.toXml(JSONStream, baos, verbose);
            result = baos.toString("UTF-8");
            baos.close();
        }
        catch (UnsupportedEncodingException uec) {
            IOException iox = new IOException(uec.toString());
            iox.initCause(uec);
            throw iox;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        return result;
    }

    public static String toXml(File jsonFile, boolean verbose) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        FileInputStream fis = new FileInputStream(jsonFile);
        String result = null;
        result = XML.toXml((InputStream)fis, verbose);
        fis.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "toXml(InputStream, boolean)");
        }
        return result;
    }

    public static String toXml(File jsonFile) throws IOException {
        return XML.toXml(jsonFile, false);
    }

    private static void convertJSONObject(Document doc, Element parent, JSONObject jObject, String tagName) {
        Set attributes = jObject.keySet();
        Iterator attrsItr = attributes.iterator();
        Element element = doc.createElement(XML.removeProblemCharacters(tagName));
        if (parent != null) {
            parent.appendChild(element);
        } else {
            doc.appendChild(element);
        }
        while (attrsItr.hasNext()) {
            String attr = (String)attrsItr.next();
            Object obj = jObject.opt(attr);
            if (obj instanceof Number) {
                element.setAttribute(attr, obj.toString());
                continue;
            }
            if (obj instanceof Boolean) {
                element.setAttribute(attr, obj.toString());
                continue;
            }
            if (obj instanceof String) {
                element.setAttribute(attr, XML.escapeEntityCharacters(obj.toString()));
                continue;
            }
            if (obj == null) {
                element.setAttribute(attr, "");
                continue;
            }
            if (obj instanceof JSONObject) {
                XML.convertJSONObject(doc, element, (JSONObject)obj, attr);
                continue;
            }
            if (!(obj instanceof JSONArray)) continue;
            XML.convertJSONArray(doc, element, (JSONArray)obj, attr);
        }
    }

    private static void convertJSONArray(Document doc, Element parent, JSONArray jArray, String tagName) {
        tagName = XML.removeProblemCharacters(tagName);
        for (int i = 0; i < jArray.size(); ++i) {
            Text tNode;
            Element element = doc.createElement(tagName);
            if (parent != null) {
                parent.appendChild(element);
            } else {
                doc.appendChild(element);
            }
            Object obj = jArray.get(i);
            if (obj instanceof Number) {
                tNode = doc.createTextNode(obj.toString());
                element.appendChild(tNode);
                continue;
            }
            if (obj instanceof Boolean) {
                tNode = doc.createTextNode(obj.toString());
                element.appendChild(tNode);
                continue;
            }
            if (obj instanceof String) {
                tNode = doc.createTextNode(XML.escapeEntityCharacters(obj.toString()));
                element.appendChild(tNode);
                continue;
            }
            if (obj instanceof JSONObject) {
                XML.convertJSONObject(doc, element, (JSONObject)obj, "jsonObject");
                continue;
            }
            if (!(obj instanceof JSONArray)) continue;
            XML.convertJSONArray(doc, element, (JSONArray)obj, "jsonArray");
        }
    }

    private static String escapeEntityCharacters(String str) {
        String retVal = null;
        if (str != null) {
            StringBuffer strBuf = new StringBuffer("");
            block7: for (int i = 0; i < str.length(); ++i) {
                char character = str.charAt(i);
                switch (character) {
                    case '&': {
                        strBuf.append("&amp;");
                        continue block7;
                    }
                    case '>': {
                        strBuf.append("&gt;");
                        continue block7;
                    }
                    case '<': {
                        strBuf.append("&lt;");
                        continue block7;
                    }
                    case '\"': {
                        strBuf.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        strBuf.append("&apos;");
                        continue block7;
                    }
                    default: {
                        strBuf.append(character);
                    }
                }
            }
            retVal = strBuf.toString();
        }
        return retVal;
    }

    private static String removeProblemCharacters(String str) {
        String retVal = null;
        if (str != null) {
            StringBuffer strBuf = new StringBuffer("");
            block3: for (int i = 0; i < str.length(); ++i) {
                char character = str.charAt(i);
                switch (character) {
                    case ' ': 
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        strBuf.append("_");
                        continue block3;
                    }
                    default: {
                        strBuf.append(character);
                    }
                }
            }
            retVal = strBuf.toString();
        }
        return retVal;
    }
}

