/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.json4j.internal;

import java.io.IOException;
import java.io.Reader;
import plugin.rtc.org.apache.wink.json4j.JSONArray;
import plugin.rtc.org.apache.wink.json4j.JSONArtifact;
import plugin.rtc.org.apache.wink.json4j.JSONException;
import plugin.rtc.org.apache.wink.json4j.JSONObject;
import plugin.rtc.org.apache.wink.json4j.OrderedJSONObject;
import plugin.rtc.org.apache.wink.json4j.internal.Token;
import plugin.rtc.org.apache.wink.json4j.internal.Tokenizer;

public class Parser {
    private Tokenizer tokenizer;
    private Token lastToken;
    private JSONArtifact jArtifact;
    private boolean firstArtifact = false;

    public Parser(Reader reader) throws JSONException {
        try {
            this.tokenizer = new Tokenizer(reader, false);
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
    }

    public Parser(Reader reader, boolean strict) throws JSONException {
        try {
            this.tokenizer = new Tokenizer(reader, strict);
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
    }

    public JSONObject parse() throws JSONException {
        return this.parse(false, (JSONObject)null);
    }

    public JSONObject parse(JSONObject jObj) throws JSONException {
        return this.parse(false, jObj);
    }

    public JSONObject parse(boolean ordered) throws JSONException {
        try {
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        return this.parseObject(ordered, null);
    }

    public JSONObject parse(boolean ordered, JSONObject jObj) throws JSONException {
        try {
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        return this.parseObject(ordered, jObj);
    }

    public JSONArray parse(JSONArray jObj) throws JSONException {
        return this.parse(false, jObj);
    }

    public JSONArray parse(boolean ordered, JSONArray jObj) throws JSONException {
        try {
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during input read.");
            jex.initCause(iox);
            throw jex;
        }
        return this.parseArray(ordered, jObj);
    }

    public JSONObject parseObject() throws JSONException {
        return this.parseObject(false, null);
    }

    public JSONObject parseObject(boolean ordered, JSONObject rootObject) throws JSONException {
        try {
            JSONObject result;
            block8: {
                result = null;
                result = rootObject != null ? rootObject : (!ordered ? new JSONObject() : new OrderedJSONObject());
                if (this.lastToken != Token.TokenBraceL) {
                    throw new JSONException("Expecting '{' " + this.tokenizer.onLineCol() + " instead, obtained token: '" + this.lastToken + "'");
                }
                this.lastToken = this.tokenizer.next();
                while (true) {
                    if (this.lastToken == Token.TokenEOF) {
                        throw new JSONException("Unterminated object " + this.tokenizer.onLineCol());
                    }
                    if (this.lastToken == Token.TokenBraceR) break block8;
                    if (!this.lastToken.isString()) {
                        throw new JSONException("Expecting string key " + this.tokenizer.onLineCol());
                    }
                    String key = this.lastToken.getString();
                    this.lastToken = this.tokenizer.next();
                    if (this.lastToken != Token.TokenColon) {
                        throw new JSONException("Expecting colon " + this.tokenizer.onLineCol());
                    }
                    this.lastToken = this.tokenizer.next();
                    Object val = this.parseValue(ordered);
                    result.put(key, val);
                    if (this.lastToken == Token.TokenComma) {
                        this.lastToken = this.tokenizer.next();
                        continue;
                    }
                    if (this.lastToken != Token.TokenBraceR) break;
                }
                throw new JSONException("expecting either ',' or '}' " + this.tokenizer.onLineCol());
            }
            this.lastToken = this.tokenizer.next();
            return result;
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during object input read.");
            jex.initCause(iox);
            throw jex;
        }
    }

    public JSONArray parseArray() throws JSONException {
        return this.parseArray(false, null);
    }

    public JSONArray parseArray(boolean ordered, JSONArray array) throws JSONException {
        JSONArray result = null;
        result = array != null ? array : new JSONArray();
        try {
            block6: {
                if (this.lastToken != Token.TokenBrackL) {
                    throw new JSONException("Expecting '[' " + this.tokenizer.onLineCol());
                }
                this.lastToken = this.tokenizer.next();
                while (true) {
                    if (this.lastToken == Token.TokenEOF) {
                        throw new JSONException("Unterminated array " + this.tokenizer.onLineCol());
                    }
                    if (this.lastToken == Token.TokenBrackR) break block6;
                    Object val = this.parseValue(ordered);
                    result.add(val);
                    if (this.lastToken == Token.TokenComma) {
                        this.lastToken = this.tokenizer.next();
                        continue;
                    }
                    if (this.lastToken != Token.TokenBrackR) break;
                }
                throw new JSONException("expecting either ',' or ']' " + this.tokenizer.onLineCol());
            }
            this.lastToken = this.tokenizer.next();
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during array input read.");
            jex.initCause(iox);
            throw jex;
        }
        return result;
    }

    public Object parseValue() throws JSONException {
        return this.parseValue(false);
    }

    public Object parseValue(boolean ordered) throws JSONException {
        if (this.lastToken == Token.TokenEOF) {
            throw new JSONException("Expecting property value " + this.tokenizer.onLineCol());
        }
        try {
            if (this.lastToken.isNumber()) {
                Number result = this.lastToken.getNumber();
                this.lastToken = this.tokenizer.next();
                return result;
            }
            if (this.lastToken.isString()) {
                String result = this.lastToken.getString();
                this.lastToken = this.tokenizer.next();
                return result;
            }
            if (this.lastToken == Token.TokenFalse) {
                this.lastToken = this.tokenizer.next();
                return Boolean.FALSE;
            }
            if (this.lastToken == Token.TokenTrue) {
                this.lastToken = this.tokenizer.next();
                return Boolean.TRUE;
            }
            if (this.lastToken == Token.TokenNull) {
                this.lastToken = this.tokenizer.next();
                return null;
            }
            if (this.lastToken == Token.TokenBrackL) {
                return this.parseArray(ordered, null);
            }
            if (this.lastToken == Token.TokenBraceL) {
                return this.parseObject(ordered, null);
            }
        }
        catch (IOException iox) {
            JSONException jex = new JSONException("Error occurred during value input read.");
            jex.initCause(iox);
            throw jex;
        }
        throw new JSONException("Invalid token " + this.tokenizer.onLineCol());
    }
}

