/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.registry;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.List;
import plugin.rtc.org.apache.wink.common.internal.registry.Injectable;
import plugin.rtc.org.apache.wink.common.internal.registry.ValueConvertor;
import plugin.rtc.org.apache.wink.common.internal.uri.UriEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BoundInjectable
extends Injectable {
    private String name;
    private ValueConvertor convertor;
    private String defaultValue;
    private boolean encoded;

    protected BoundInjectable(Injectable.ParamType paramType, String name, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
        super(paramType, type, genericType, annotations, member);
        this.name = name;
        this.convertor = ValueConvertor.createValueConvertor(type, genericType);
        this.defaultValue = null;
        this.encoded = false;
    }

    public String getName() {
        return this.name;
    }

    public ValueConvertor getConvertor() {
        return this.convertor;
    }

    protected void setConvertor(ValueConvertor convertor) {
        this.convertor = convertor;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public void setEncoded(boolean encoded) {
        this.encoded = encoded;
    }

    protected String decodeValue(String value) {
        return UriEncoder.decodeString(value);
    }

    protected void decodeValues(List<String> values) {
        if (values == null || this.isEncoded()) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            values.set(i, this.decodeValue(values.get(i)));
        }
    }
}

