/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.header;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.ext.RuntimeDelegate;
import plugin.rtc.org.apache.wink.common.internal.http.AcceptEncoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptEncodingHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<AcceptEncoding> {
    private static final Logger logger = LoggerFactory.getLogger(AcceptEncodingHeaderDelegate.class);

    @Override
    public AcceptEncoding fromString(String value) throws IllegalArgumentException {
        LinkedList<String> acceptable = new LinkedList<String>();
        LinkedList<String> banned = new LinkedList<String>();
        boolean anyAllowed = value == null;
        List<AcceptEncoding.ValuedEncoding> vEncodings = this.parseAcceptEncoding(value);
        for (AcceptEncoding.ValuedEncoding qEncoding : vEncodings) {
            logger.trace("Processing {} with qValue {}", (Object)qEncoding.encoding, (Object)qEncoding.qValue);
            if (anyAllowed) {
                logger.trace("anyAllowed is true");
                if (qEncoding.qValue != 0.0 || qEncoding.isWildcard()) continue;
                logger.trace("qValue is 0 and qEncoding is not a wildcard so {} is banned", (Object)qEncoding.encoding);
                banned.add(qEncoding.encoding);
                continue;
            }
            logger.trace("anyAllowed is still false");
            if (qEncoding.qValue == 0.0) {
                logger.trace("qValue is 0 so breaking out of loop");
                break;
            }
            if (qEncoding.isWildcard()) {
                logger.trace("qEncoding is a wildcard so everything afterwards is allowable");
                anyAllowed = true;
                continue;
            }
            logger.trace("qEncoding is not a wildcard so adding to acceptable list");
            acceptable.add(qEncoding.encoding);
        }
        return new AcceptEncoding(value, acceptable, banned, anyAllowed, vEncodings);
    }

    private List<AcceptEncoding.ValuedEncoding> parseAcceptEncoding(String acceptableEncodingValue) {
        logger.trace("parseAcceptEncoding({}) entry", (Object)acceptableEncodingValue);
        LinkedList<AcceptEncoding.ValuedEncoding> qEncodings = new LinkedList<AcceptEncoding.ValuedEncoding>();
        if (acceptableEncodingValue == null) {
            logger.trace("parseAcceptEncoding() exit - return empty list");
            return qEncodings;
        }
        for (String encodingRange : acceptableEncodingValue.split(",")) {
            String encodingSpec;
            double qValue;
            logger.trace("Parsing encodingRange as {}", (Object)encodingRange);
            int semicolonIndex = encodingRange.indexOf(59);
            if (semicolonIndex == -1) {
                qValue = 1.0;
                encodingSpec = encodingRange;
            } else {
                encodingSpec = encodingRange.substring(0, semicolonIndex);
                int equalsIndex = encodingRange.indexOf(61, semicolonIndex + 1);
                String qString = encodingRange.substring(equalsIndex != -1 ? equalsIndex + 1 : encodingRange.length());
                try {
                    qValue = Double.parseDouble(qString.trim());
                }
                catch (NumberFormatException nfe) {
                    qValue = 1.0;
                }
            }
            logger.trace("encodingSpec before trim is {}", (Object)encodingSpec);
            logger.trace("qValue is {}", (Object)qValue);
            encodingSpec = encodingSpec.trim();
            if (encodingSpec.length() == 0) {
                logger.trace("ignoring empty encodingSpec");
                continue;
            }
            if (encodingSpec.equals("*")) {
                logger.trace("Wildcard spec so adding as wildcard");
                qEncodings.add(new AcceptEncoding.ValuedEncoding(qValue, null));
                continue;
            }
            qEncodings.add(new AcceptEncoding.ValuedEncoding(qValue, encodingSpec));
        }
        Collections.sort(qEncodings, Collections.reverseOrder());
        logger.trace("parseAcceptEncoding exit() returning {}", qEncodings);
        return qEncodings;
    }

    @Override
    public String toString(AcceptEncoding value) {
        return value.getAcceptEncodingHeader();
    }
}

