/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.entity;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.UUID;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.Context;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Provider;
import plugin.rtc.javax.ws.rs.ext.Providers;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.utils.ExceptionHelper;
import plugin.rtc.org.apache.wink.common.internal.utils.MediaTypeUtils;
import plugin.rtc.org.apache.wink.common.model.synd.SyndContent;
import plugin.rtc.org.apache.wink.common.model.synd.SyndEntry;
import plugin.rtc.org.apache.wink.common.model.synd.SyndText;
import plugin.rtc.org.apache.wink.common.utils.ProviderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class FormatedExceptionProvider
implements MessageBodyWriter<Throwable> {
    private static final String ID_PREFIX = "urn:uuid:";
    @Context
    private Providers providers;

    @Override
    public long getSize(Throwable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Throwable.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(Throwable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Class<?> rawType;
        SyndEntry se = new SyndEntry();
        Class<?> genType = rawType = se.getClass();
        String defaultErrorMessage = Messages.getMessage("errorOccurredProcessingRequest");
        MessageBodyWriter<?> messageBodyWriter = this.providers.getMessageBodyWriter(rawType, genType, null, mediaType);
        String localizedMessage = t.getLocalizedMessage();
        String string = localizedMessage = localizedMessage == null ? defaultErrorMessage : localizedMessage;
        if (messageBodyWriter != null) {
            se.setId(ID_PREFIX + UUID.randomUUID());
            se.setUpdated(new Date(System.currentTimeMillis()));
            se.setPublished(new Date(System.currentTimeMillis()));
            se.setTitle(new SyndText(localizedMessage));
            SyndContent syndContent = new SyndContent();
            syndContent.setType("text/plain");
            syndContent.setValue(ExceptionHelper.stackTraceToString(t));
            se.setContent(syndContent);
            se.setSummary(new SyndText(localizedMessage));
            messageBodyWriter.writeTo(se, rawType, genType, null, mediaType, httpHeaders, entityStream);
        } else {
            localizedMessage = "<error>" + localizedMessage + "</error>";
            mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, mediaType);
            entityStream.write(localizedMessage.getBytes(ProviderUtils.getCharset(mediaType)));
        }
    }
}

