/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Providers;
import plugin.rtc.org.apache.wink.common.RuntimeContext;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.model.ModelUtils;
import plugin.rtc.org.apache.wink.common.internal.model.XmlWrapper;
import plugin.rtc.org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import plugin.rtc.org.apache.wink.common.utils.ProviderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyContentHandler
implements DomHandler<XmlWrapper, StreamResult> {
    private static final Logger logger = LoggerFactory.getLogger(AnyContentHandler.class);

    public StreamResult createUnmarshaller(ValidationEventHandler errorHandler) {
        return new StreamResult(new ByteArrayOutputStream());
    }

    public XmlWrapper getElement(StreamResult rt) {
        return new XmlWrapper(((ByteArrayOutputStream)rt.getOutputStream()).toByteArray(), null);
    }

    public Source marshal(XmlWrapper xmlWrapper, ValidationEventHandler errorHandler) {
        byte[] result;
        Class<?> cls;
        MediaType type = null;
        String contentType = xmlWrapper.getType();
        type = contentType == null ? MediaType.APPLICATION_OCTET_STREAM_TYPE : (contentType.equals("xhtml") ? MediaType.APPLICATION_XML_TYPE : MediaType.valueOf(contentType));
        RuntimeContext runtimeContext = RuntimeContextTLS.getRuntimeContext();
        Providers providers = runtimeContext.getProviders();
        MessageBodyWriter<?> writer = providers.getMessageBodyWriter(cls = xmlWrapper.getValue().getClass(), cls, null, type);
        if (writer == null) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("noWriterFound", cls.getName(), type.toString()));
            }
            throw new WebApplicationException(500);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            writer.writeTo(xmlWrapper.getValue(), cls, cls, ModelUtils.EMPTY_ARRAY, type, ModelUtils.EMPTY_OBJECT_MAP, os);
        }
        catch (IOException e) {
            throw new WebApplicationException(e);
        }
        if (contentType.equals("xhtml")) {
            try {
                result = ("<div xmlns=\"" + "http://www.w3.org/1999/xhtml" + "\">" + os.toString(ProviderUtils.getCharset(type)) + "</div>").getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new WebApplicationException(e);
            }
        } else {
            result = os.toByteArray();
        }
        return new StreamSource(new ByteArrayInputStream(result));
    }
}

