/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import plugin.rtc.javax.ws.rs.core.CacheControl;
import plugin.rtc.javax.ws.rs.core.EntityTag;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.core.NewCookie;
import plugin.rtc.javax.ws.rs.core.Response;
import plugin.rtc.javax.ws.rs.core.UriBuilder;
import plugin.rtc.javax.ws.rs.core.UriInfo;
import plugin.rtc.javax.ws.rs.core.Variant;
import plugin.rtc.org.apache.wink.common.RuntimeContext;
import plugin.rtc.org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;
import plugin.rtc.org.apache.wink.common.internal.runtime.RuntimeContextTLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseImpl
extends Response {
    private static final int DEFAULT_STATUS = -1;
    private Object entity;
    private int status = -1;
    private MultivaluedMap<String, Object> metadata;

    private ResponseImpl(int status, Object entity, MultivaluedMap<String, Object> metadata) {
        this.status = status;
        this.entity = entity;
        this.metadata = metadata;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public MultivaluedMap<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResponseBuilderImpl
    extends Response.ResponseBuilder {
        private Object entity;
        private int status;
        private final MultivaluedMap<String, Object> metadata;

        public ResponseBuilderImpl() {
            this.metadata = new CaseInsensitiveMultivaluedMap<Object>();
            this.status = -1;
        }

        private ResponseBuilderImpl(int status, Object entity, MultivaluedMap<String, Object> metadata) {
            this.status = status;
            this.entity = entity;
            this.metadata = metadata;
        }

        @Override
        public Response build() {
            return new ResponseImpl(this.status, this.entity, this.metadata);
        }

        @Override
        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            return this.singleHeader("Cache-Control", cacheControl);
        }

        @Override
        public Response.ResponseBuilder clone() {
            return new ResponseBuilderImpl(this.status, this.entity, this.metadata);
        }

        @Override
        public Response.ResponseBuilder contentLocation(URI location) {
            return this.singleHeader("Content-Location", location);
        }

        @Override
        public Response.ResponseBuilder cookie(NewCookie ... cookies) {
            if (cookies == null) {
                this.metadata.remove("Set-Cookie");
            } else {
                for (NewCookie cookie : cookies) {
                    this.header("Set-Cookie", cookie);
                }
            }
            return this;
        }

        @Override
        public Response.ResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Response.ResponseBuilder expires(Date expires) {
            return this.singleHeader("Expires", expires);
        }

        @Override
        public Response.ResponseBuilder header(String name, Object value) {
            if (value == null) {
                this.metadata.remove(name);
            } else {
                this.metadata.add(name, value);
            }
            return this;
        }

        @Override
        public Response.ResponseBuilder language(String language) {
            return this.singleHeader("Content-Language", language);
        }

        @Override
        public Response.ResponseBuilder language(Locale language) {
            return this.singleHeader("Content-Language", language);
        }

        @Override
        public Response.ResponseBuilder lastModified(Date lastModified) {
            return this.singleHeader("Last-Modified", lastModified);
        }

        @Override
        public Response.ResponseBuilder location(URI location) {
            UriInfo info;
            RuntimeContext rtContext;
            if (location != null && !location.isAbsolute() && (rtContext = RuntimeContextTLS.getRuntimeContext()) != null && (info = RuntimeContextTLS.getRuntimeContext().getAttribute(UriInfo.class)) != null) {
                location = UriBuilder.fromUri(info.getBaseUri()).path(location.getPath()).fragment(location.getFragment()).build(new Object[0]);
            }
            return this.singleHeader("Location", location);
        }

        @Override
        public Response.ResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        @Override
        public Response.ResponseBuilder tag(EntityTag tag) {
            return this.singleHeader("ETag", tag);
        }

        @Override
        public Response.ResponseBuilder tag(String tag) {
            return this.singleHeader("ETag", tag);
        }

        @Override
        public Response.ResponseBuilder type(MediaType type) {
            return this.singleHeader("Content-Type", type);
        }

        @Override
        public Response.ResponseBuilder type(String type) {
            return this.singleHeader("Content-Type", type);
        }

        public Response.ResponseBuilder encoding(String encoding) {
            return this.singleHeader("Content-Encoding", encoding);
        }

        @Override
        public Response.ResponseBuilder variant(Variant variant) {
            if (variant != null) {
                this.language(variant.getLanguage());
                this.encoding(variant.getEncoding());
                this.type(variant.getMediaType());
            } else {
                this.language((String)null);
                this.encoding(null);
                this.type((String)null);
            }
            return this;
        }

        @Override
        public Response.ResponseBuilder variants(List<Variant> variants) {
            if (variants == null) {
                this.header("Vary", null);
                return this;
            }
            if (variants.isEmpty()) {
                return this;
            }
            boolean encoding = false;
            boolean lang = false;
            boolean mediatype = false;
            for (Variant v : variants) {
                encoding = encoding || v.getEncoding() != null;
                lang = lang || v.getLanguage() != null;
                mediatype = mediatype || v.getMediaType() != null;
            }
            StringBuilder sb = new StringBuilder();
            this.conditionalAppend(sb, mediatype, "Accept");
            this.conditionalAppend(sb, lang, "Accept-Language");
            this.conditionalAppend(sb, encoding, "Accept-Encoding");
            if (sb.length() > 0) {
                this.header("Vary", sb.toString());
            }
            return this;
        }

        private Response.ResponseBuilder singleHeader(String key, Object value) {
            if (value == null) {
                this.metadata.remove(key);
            } else {
                this.metadata.putSingle(key, value);
            }
            return this;
        }

        private void conditionalAppend(StringBuilder sb, boolean b, String s) {
            if (b) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(s);
            }
        }
    }
}

