/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.http.protocol;

import java.io.IOException;
import plugin.rtc.org.apache.http.HttpException;
import plugin.rtc.org.apache.http.HttpRequest;
import plugin.rtc.org.apache.http.HttpRequestInterceptor;
import plugin.rtc.org.apache.http.annotation.Contract;
import plugin.rtc.org.apache.http.annotation.ThreadingBehavior;
import plugin.rtc.org.apache.http.protocol.HttpContext;
import plugin.rtc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

