/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.http.impl.cookie;

import plugin.rtc.org.apache.http.annotation.Contract;
import plugin.rtc.org.apache.http.annotation.ThreadingBehavior;
import plugin.rtc.org.apache.http.cookie.CommonCookieAttributeHandler;
import plugin.rtc.org.apache.http.cookie.Cookie;
import plugin.rtc.org.apache.http.cookie.CookieOrigin;
import plugin.rtc.org.apache.http.cookie.MalformedCookieException;
import plugin.rtc.org.apache.http.cookie.SetCookie;
import plugin.rtc.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import plugin.rtc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

