/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import plugin.rtc.org.apache.http.HttpException;
import plugin.rtc.org.apache.http.HttpResponse;
import plugin.rtc.org.apache.http.HttpResponseFactory;
import plugin.rtc.org.apache.http.NoHttpResponseException;
import plugin.rtc.org.apache.http.ProtocolException;
import plugin.rtc.org.apache.http.StatusLine;
import plugin.rtc.org.apache.http.config.MessageConstraints;
import plugin.rtc.org.apache.http.impl.DefaultHttpResponseFactory;
import plugin.rtc.org.apache.http.impl.io.AbstractMessageParser;
import plugin.rtc.org.apache.http.io.SessionInputBuffer;
import plugin.rtc.org.apache.http.message.LineParser;
import plugin.rtc.org.apache.http.message.ParserCursor;
import plugin.rtc.org.apache.http.params.HttpParams;
import plugin.rtc.org.apache.http.util.Args;
import plugin.rtc.org.apache.http.util.CharArrayBuffer;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        Args.notNull(responseFactory, "Response factory");
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        int count = 0;
        ParserCursor cursor = null;
        while (true) {
            this.lineBuf.clear();
            int i = sessionBuffer.readLine(this.lineBuf);
            if (i == -1 && count == 0) {
                throw new NoHttpResponseException("The target server failed to respond");
            }
            cursor = new ParserCursor(0, this.lineBuf.length());
            if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
            if (i == -1 || this.reject(this.lineBuf, count)) {
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Garbage in response: " + this.lineBuf.toString()));
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }

    protected boolean reject(CharArrayBuffer line, int count) {
        return false;
    }
}

