/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.net.oauth.signature.pem;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.RSAPrivateCrtKeySpec;
import plugin.rtc.net.oauth.signature.pem.Asn1Object;
import plugin.rtc.net.oauth.signature.pem.DerParser;

public class PKCS1EncodedKeySpec {
    private RSAPrivateCrtKeySpec keySpec;

    public PKCS1EncodedKeySpec(byte[] keyBytes) throws IOException {
        this.decode(keyBytes);
    }

    public RSAPrivateCrtKeySpec getKeySpec() {
        return this.keySpec;
    }

    private void decode(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        this.keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
    }
}

