/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.net.oauth.client.httpclient4;

import java.io.IOException;
import plugin.rtc.org.apache.http.HttpException;
import plugin.rtc.org.apache.http.HttpHost;
import plugin.rtc.org.apache.http.HttpRequest;
import plugin.rtc.org.apache.http.HttpRequestInterceptor;
import plugin.rtc.org.apache.http.auth.AuthScheme;
import plugin.rtc.org.apache.http.auth.AuthSchemeRegistry;
import plugin.rtc.org.apache.http.auth.AuthScope;
import plugin.rtc.org.apache.http.auth.AuthState;
import plugin.rtc.org.apache.http.auth.Credentials;
import plugin.rtc.org.apache.http.client.CredentialsProvider;
import plugin.rtc.org.apache.http.protocol.HttpContext;

public class PreemptiveAuthorizer
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState != null && authState.getAuthScheme() != null) {
            return;
        }
        HttpHost target = (HttpHost)context.getAttribute("http.target_host");
        CredentialsProvider creds = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        AuthSchemeRegistry schemes = (AuthSchemeRegistry)context.getAttribute("http.authscheme-registry");
        for (Object schemeName : (Iterable)context.getAttribute("http.auth.scheme-pref")) {
            AuthScope targetScope;
            Credentials cred;
            AuthScheme scheme = schemes.getAuthScheme(schemeName.toString(), request.getParams());
            if (scheme == null || (cred = creds.getCredentials(targetScope = new AuthScope(target.getHostName(), target.getPort(), scheme.getRealm(), scheme.getSchemeName()))) == null) continue;
            authState.setAuthScheme(scheme);
            authState.setCredentials(cred);
            return;
        }
    }
}

