/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.util.iterator;

import java.util.HashSet;
import java.util.Iterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.WrappedIterator;

public class UniqueExtendedIterator<T>
extends WrappedIterator<T> {
    protected HashSet<T> seen = new HashSet();
    protected T next = null;

    public UniqueExtendedIterator(Iterator<T> underlying) {
        super(underlying, true);
    }

    public static <T> ExtendedIterator<T> create(Iterator<T> it) {
        return it instanceof UniqueExtendedIterator ? (UniqueExtendedIterator<T>)it : new UniqueExtendedIterator<T>(it);
    }

    protected T nextIfNew() {
        Object value = super.next();
        return (T)(this.seen.add(value) ? value : null);
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && super.hasNext()) {
            this.next = this.nextIfNew();
        }
        return this.next != null;
    }

    @Override
    public T next() {
        this.ensureHasNext();
        T result = this.next;
        this.next = null;
        return result;
    }
}

