/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.util.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ClosableIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Filter;
import plugin.rtc.com.hp.hpl.jena.util.iterator.FilterDropIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.FilterKeepIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1Iterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.NullIterator;

public class NiceIterator<T>
implements ExtendedIterator<T> {
    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    protected void ensureHasNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public T next() {
        throw new NoSuchElementException("empty NiceIterator");
    }

    protected T noElements(String message) {
        throw new NoSuchElementException(message);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported for this iterator");
    }

    @Override
    public T removeNext() {
        T result = this.next();
        this.remove();
        return result;
    }

    public static <T> ExtendedIterator<T> andThen(final Iterator<T> a, Iterator<? extends T> b) {
        final ArrayList<Iterator<? extends T>> pending = new ArrayList<Iterator<? extends T>>(2);
        pending.add(b);
        return new NiceIterator<T>(){
            private int index = 0;
            private Iterator<? extends T> current = a;
            private Iterator<? extends T> removeFrom = null;

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext() && this.index < pending.size()) {
                    this.current = this.advance();
                }
                return this.current.hasNext();
            }

            private Iterator<? extends T> advance() {
                Iterator result = (Iterator)pending.get(this.index);
                pending.set(this.index, null);
                ++this.index;
                return result;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    this.noElements("concatenation");
                }
                this.removeFrom = this.current;
                return this.current.next();
            }

            @Override
            public void close() {
                1.close(this.current);
                for (int i = this.index; i < pending.size(); ++i) {
                    1.close((Iterator)pending.get(i));
                }
                pending.clear();
                this.removeFrom = null;
            }

            @Override
            public void remove() {
                if (null == this.removeFrom) {
                    throw new IllegalStateException("no calls to next() since last call to remove()");
                }
                this.removeFrom.remove();
                this.removeFrom = null;
            }

            @Override
            public <X extends T> ExtendedIterator<T> andThen(Iterator<X> other) {
                pending.add(other);
                return this;
            }
        };
    }

    @Override
    public <X extends T> ExtendedIterator<T> andThen(Iterator<X> other) {
        return NiceIterator.andThen(this, other);
    }

    @Override
    public ExtendedIterator<T> filterKeep(Filter<T> f) {
        return new FilterKeepIterator<T>(f, this);
    }

    @Override
    public ExtendedIterator<T> filterDrop(Filter<T> f) {
        return new FilterDropIterator<T>(f, this);
    }

    @Override
    public <U> ExtendedIterator<U> mapWith(Map1<T, U> map1) {
        return new Map1Iterator<T, U>(map1, this);
    }

    public static void close(Iterator<?> it) {
        if (it instanceof ClosableIterator) {
            ((ClosableIterator)it).close();
        }
    }

    public static <T> ExtendedIterator<T> emptyIterator() {
        return NullIterator.instance();
    }

    @Override
    public List<T> toList() {
        return NiceIterator.asList(this);
    }

    @Override
    public Set<T> toSet() {
        return NiceIterator.asSet(this);
    }

    public static <T> Set<T> asSet(ExtendedIterator<T> it) {
        HashSet result = new HashSet();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<T> asList(ExtendedIterator<T> it) {
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }
}

