/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.builtins;

import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.Builtin;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.RuleContext;

public abstract class BaseBuiltin
implements Builtin {
    public static final String BASE_URI = "http://jena.hpl.hp.com/2003/RuleBuiltin/";

    @Override
    public String getURI() {
        return BASE_URI + this.getName();
    }

    @Override
    public int getArgLength() {
        return 0;
    }

    public void checkArgs(int length, RuleContext context) {
        int expected = this.getArgLength();
        if (expected > 0 && expected != length) {
            throw new BuiltinException(this, context, "builtin " + this.getName() + " requires " + expected + " arguments but saw " + length);
        }
    }

    @Override
    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        throw new BuiltinException(this, context, "builtin " + this.getName() + " not usable in rule bodies");
    }

    @Override
    public void headAction(Node[] args, int length, RuleContext context) {
        throw new BuiltinException(this, context, "builtin " + this.getName() + " not usable in rule heads");
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public boolean isMonotonic() {
        return true;
    }

    public Node getArg(int n, Node[] args, RuleContext context) {
        return context.getEnv().getGroundVersion(args[n]);
    }
}

