/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.graph.impl;

import plugin.rtc.com.hp.hpl.jena.JenaRuntime;
import plugin.rtc.com.hp.hpl.jena.datatypes.DatatypeFormatException;
import plugin.rtc.com.hp.hpl.jena.datatypes.RDFDatatype;
import plugin.rtc.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import plugin.rtc.com.hp.hpl.jena.graph.NodeFactory;
import plugin.rtc.com.hp.hpl.jena.graph.impl.LiteralLabel;
import plugin.rtc.com.hp.hpl.jena.graph.impl.LiteralLabelImpl;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDF;

public class LiteralLabelFactory {
    private static final RDFDatatype dtSLangString = NodeFactory.getType(RDF.Nodes.langString.getURI());

    private static RDFDatatype fixDatatype(RDFDatatype dtype, String lang) {
        if (dtype != null) {
            return dtype;
        }
        if (JenaRuntime.isRDF11) {
            dtype = lang == null || lang.equals("") ? XSDDatatype.XSDstring : dtSLangString;
        }
        return dtype;
    }

    public static LiteralLabel create(String lex, RDFDatatype dtype) {
        return new LiteralLabelImpl(lex, "", dtype);
    }

    public static LiteralLabel createLiteralLabel(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        dtype = LiteralLabelFactory.fixDatatype(dtype, lang);
        return new LiteralLabelImpl(lex, lang, dtype);
    }

    public static LiteralLabel create(String lex, String lang) {
        RDFDatatype dt = LiteralLabelFactory.fixDatatype(null, lang);
        return new LiteralLabelImpl(lex, lang, dt);
    }

    public static LiteralLabel create(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        dtype = LiteralLabelFactory.fixDatatype(dtype, lang);
        return new LiteralLabelImpl(value, lang, dtype);
    }

    @Deprecated
    public static LiteralLabel create(Object value) {
        return LiteralLabelFactory.createTypedLiteral(value);
    }

    public static LiteralLabel createTypedLiteral(Object value) {
        return new LiteralLabelImpl(value);
    }

    public static LiteralLabel create(String s, String lang, boolean xml) {
        if (xml) {
            return new LiteralLabelImpl(s, lang, xml);
        }
        return LiteralLabelFactory.create(s, lang);
    }
}

