/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.rtc;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.rtc.RtcConnector;
import org.squashtest.tm.service.spi.OslcBugTrackerConnector;
import org.squashtest.tm.service.spi.OslcBugTrackerConnectorProvider;

@Service(value="squashtest.core.bugtracker.rtcConnectorProvider")
public class RtcConnectorProvider
implements OslcBugTrackerConnectorProvider {
    private static final String KIND = "rtc";
    private static final String LABEL = "rtc connector";
    @Inject
    private Provider<RtcConnector> connectorProvider;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public OslcBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullPointerException("bugTracker");
        }
        RtcConnector connector = (RtcConnector)this.connectorProvider.get();
        connector.setBugTracker(bugTracker);
        return connector;
    }
}

