/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariableBinding;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.rest.admin.controller.RestAiServerController;
import org.squashtest.tm.plugin.rest.admin.controller.RestBugTrackerController;
import org.squashtest.tm.plugin.rest.admin.controller.RestScmRepositoryController;
import org.squashtest.tm.plugin.rest.admin.jackson.model.BugTrackerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.BugTrackerProjectDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ProjectAutomationConfigurationDto;
import org.squashtest.tm.plugin.rest.admin.service.RestAiServerService;
import org.squashtest.tm.plugin.rest.admin.service.RestBugTrackerService;
import org.squashtest.tm.plugin.rest.admin.service.RestCustomFieldService;
import org.squashtest.tm.plugin.rest.admin.service.RestEnvironmentVariableService;
import org.squashtest.tm.plugin.rest.admin.service.RestInfoListService;
import org.squashtest.tm.plugin.rest.admin.service.RestMilestoneService;
import org.squashtest.tm.plugin.rest.admin.service.RestProjectAdminService;
import org.squashtest.tm.plugin.rest.admin.validators.ProjectValidator;
import org.squashtest.tm.plugin.rest.controller.RestProjectController;
import org.squashtest.tm.plugin.rest.controller.RestTestAutomationServerController;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;

@RestApiController
@UseDefaultRestApiConfiguration
public class RestProjectAdminController
extends BaseRestController {
    private static final String PROJECT = "project";
    @Inject
    private RestMilestoneService restMilestoneService;
    @Inject
    private GenericProjectDao projectDao;
    @Inject
    private RestCustomFieldService cufService;
    @Inject
    private RestBugTrackerService btService;
    @Inject
    private RestInfoListService infoListService;
    @Inject
    private RestProjectAdminService restProjectAdminService;
    @Inject
    private GenericProjectManagerService genericProjectManager;
    @Inject
    private ProjectValidator projectValidator;
    @Inject
    private RestEnvironmentVariableService environmentVariableService;
    @Inject
    private RestAiServerService aiServerService;

    @DeleteMapping(value={"projects/{ids}"})
    @ResponseBody
    public ResponseEntity<Void> deleteProjectByIds(@PathVariable(value="ids") List<Long> projectIds) {
        this.restProjectAdminService.deleteProjectByIds(projectIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"projects/{id}/custom-fields/{entity-type}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> bindCustomFieldtoProject(@PathVariable(value="id") Long projectId, @PathVariable(value="entity-type") String entity, @RequestParam(value="cufId") Long cufId) {
        this.cufService.bindCustomFieldToProject(projectId, BindableEntity.valueOf((String)entity), cufId, null);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"projects/{id}/custom-fields/{entity-type}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> unbindCustomFieldtoProject(@PathVariable(value="id") Long projectId, @PathVariable(value="entity-type") String entity, @RequestParam(value="cufId") Long cufId) {
        this.cufService.unbindCustomFieldToProject(projectId, BindableEntity.valueOf((String)entity), cufId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"projects/{id}/environment-variables/{evIds}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> bindEnvironmentVariablesToProject(@PathVariable(value="id") Long projectId, @PathVariable(value="evIds") List<Long> evIds) {
        this.environmentVariableService.bindEnvironmentVariableToProject(projectId, evIds);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"projects/{id}/environment-variables/{evIds}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<Void> unbindEnvironmentVariablesToProject(@PathVariable(value="id") Long projectId, @PathVariable(value="evIds") List<Long> evIds) {
        this.environmentVariableService.unbindEnvironmentVariableToProject(projectId, evIds);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"projects/{id}/environment-variables/{evId}/value"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EnvironmentVariableBinding> setDefaultValueOfAnEnvironmentVariableToProject(@PathVariable(value="id") Long projectId, @PathVariable(value="evId") Long evId, @RequestBody EnvironmentVariableBinding evb) {
        EnvironmentVariableBinding environmentVariableBinding = this.environmentVariableService.setDefaultValueOfAnEnvironmentVariableToProject(projectId, evId, evb.getValue());
        return ResponseEntity.ok((Object)environmentVariableBinding);
    }

    @PostMapping(value={"/projects/{id}/info-lists/{list-type}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<String> setRequirementCategoryInfoListByProject(@PathVariable(value="id") Long projectId, @PathVariable(value="list-type") String listType, @RequestParam(value="infolist-id") Long infoListId) {
        switch (listType) {
            case "requirement-category": {
                this.infoListService.bindListToProjectReqCategory(infoListId, projectId);
                break;
            }
            case "test-case-nature": {
                this.infoListService.bindListToProjectTcNature(infoListId, projectId);
                break;
            }
            case "test-case-type": {
                this.infoListService.bindListToProjectTcType(infoListId, projectId);
                break;
            }
            default: {
                throw new IllegalArgumentException("List type can only have three values : requirement-category, test-case-nature, test-case-type");
            }
        }
        return ResponseEntity.ok((Object)("infolist '" + String.valueOf(infoListId) + "' bind to project " + String.valueOf(projectId) + " for " + listType));
    }

    @PostMapping(value={"/projects/{id}/milestones"})
    @ResponseBody
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<GenericProject>> bindMilestonesToProject(@PathVariable(value="id") Long projectId, @RequestParam(value="milestoneIds") List<Long> milestoneIds) {
        GenericProject project = this.restMilestoneService.bindMilestonesToProject(projectId, milestoneIds);
        EntityModel res = this.toEntityModel((Identified)project);
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectAdminController)((Object)WebMvcLinkBuilder.methodOn(RestProjectAdminController.class, (Object[])new Object[0]))).findMilestonesByProject(project.getId(), null))).withRel("milestones"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/milestones"})
    @ResponseBody
    @DynamicFilterExpression
    public ResponseEntity<PagedModel<EntityModel<Milestone>>> findMilestonesByProject(@PathVariable(value="id") Long projectId, Pageable pageable) {
        List<Milestone> milestones = this.restMilestoneService.findMilestonesByProject(projectId);
        PageImpl milestonePage = new PageImpl(milestones, pageable, (long)milestones.size());
        PagedModel res = this.toPagedModel((Page)milestonePage);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/projects/{id}/bug-trackers"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<GenericProject>> bindBugtrackerToProject(@PathVariable(value="id") Long projectId, @RequestParam(value="bugtrackerId") Long bugtrackerId) {
        this.restProjectAdminService.changeBugTracker(projectId, bugtrackerId);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestBugTrackerController)WebMvcLinkBuilder.methodOn(RestBugTrackerController.class, (Object[])new Object[0])).findBugTrackerById(bugtrackerId)));
        res.add(Link.of((String)builder.toString(), (String)"bug-tracker"));
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/projects/{id}/bug-tracker"})
    public ResponseEntity<EntityModel<GenericProject>> unbindBugTrackerFromProject(@PathVariable(value="id") long projectId) {
        this.restProjectAdminService.unbindBugTracker(projectId);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/bug-trackers"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<BugTrackerDto>> getBugtrackerForProject(@PathVariable(value="id") Long projectId) {
        BugTracker bt = this.btService.getBugTrackerByProjectId(projectId);
        EntityModel<BugTrackerDto> res = this.customToResource(bt);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestBugTrackerController)WebMvcLinkBuilder.methodOn(RestBugTrackerController.class, (Object[])new Object[0])).findBugTrackerById(bt.getId())));
        res.add(Link.of((String)builder.toString(), (String)"self"));
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/projects/{id}/bug-trackers-projects"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<BugTrackerProjectDto> getAllBugtrackerProjectBindToGivenSquashProject(@PathVariable(value="id") Long projectId) {
        BugTrackerProjectDto btProjDto = new BugTrackerProjectDto();
        btProjDto.setBugtracker(this.bugtrackerToBugtrackerDto(this.btService.getBugTrackerByProjectId(projectId)));
        btProjDto.setBugtrackerPojectList(this.btService.getBugTrackerProjectOfSquashProject(projectId));
        return ResponseEntity.ok((Object)btProjDto);
    }

    @PostMapping(value={"/projects/{id}/bug-trackers-projects"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<BugTrackerProjectDto> bindProjectFromBugtrackerToSquashProject(@RequestBody BugTrackerProjectDto bugTrackerProjectDto, @PathVariable(value="id") Long projectId) {
        this.btService.setBugTrackerProjectOnSquashProject(bugTrackerProjectDto, projectId);
        return this.getAllBugtrackerProjectBindToGivenSquashProject(projectId);
    }

    @DeleteMapping(value={"/projects/{id}/bug-trackers-projects"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity<BugTrackerProjectDto> deleteBugtrackerProjectBindToGivenSquashProject(@RequestBody BugTrackerProjectDto bugTrackerProjectDto, @PathVariable(value="id") Long projectId) {
        this.btService.deleteBugTrackerProjectOnSquashProject(bugTrackerProjectDto, projectId);
        return this.getAllBugtrackerProjectBindToGivenSquashProject(projectId);
    }

    @GetMapping(value={"/projects/{id}/automation-conf"})
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<ProjectAutomationConfigurationDto>> getProjectAutomationConfiguration(@PathVariable(value="id") long projectId) {
        ProjectAutomationConfigurationDto automSettingsDto = this.restProjectAdminService.getProjectAutomationSettings(projectId);
        return this.buildAutomConfigResponseEntity(projectId, automSettingsDto);
    }

    @PatchMapping(value={"/projects/{id}/automation-conf"})
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<ProjectAutomationConfigurationDto>> patchProjectAutomationConfiguration(@RequestBody ProjectAutomationConfigurationDto automConfDtoPatch, @PathVariable(value="id") long projectId) throws BindException {
        ProjectAutomationConfigurationDto automConfDto = this.restProjectAdminService.patchProjectAutomationConfiguration(automConfDtoPatch, projectId);
        return this.buildAutomConfigResponseEntity(projectId, automConfDto);
    }

    @PostMapping(value={"/projects/{id}/plugins/{pluginName}/activate"})
    @DynamicFilterExpression
    public ResponseEntity<Void> activateOrDeactivatePluginOnProject(@PathVariable(value="id") long projectId, @PathVariable(value="pluginName") String pluginId, @RequestParam(value="enabled") Boolean pluginEnable, @RequestParam(name="saveConfig", required=false, defaultValue="true") Boolean saveConfig) {
        if (pluginEnable.booleanValue()) {
            this.restProjectAdminService.activateProjectPluginById(projectId, pluginId);
        } else {
            this.restProjectAdminService.deactivateProjectPluginById(projectId, pluginId, saveConfig);
        }
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/projects/{id}/scm-repository"})
    public ResponseEntity<EntityModel<GenericProject>> bindScmRepositoryToProject(@PathVariable(value="id") long projectId, @RequestParam(value="scmRepositoryId") long scmRepositoryId) {
        this.restProjectAdminService.bindScmRepository(projectId, scmRepositoryId);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestScmRepositoryController)WebMvcLinkBuilder.methodOn(RestScmRepositoryController.class, (Object[])new Object[0])).findScmRepositoryById(scmRepositoryId)));
        res.add(builder.withRel("scm-repository"));
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/projects/{id}/scm-repository"})
    public ResponseEntity<EntityModel<GenericProject>> unbindScmRepositoryFromProject(@PathVariable(value="id") long projectId) {
        this.restProjectAdminService.unbindScmRepository(projectId);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/projects/{id}/test-automation-server"})
    public ResponseEntity<EntityModel<GenericProject>> bindTestAutomationServerToProject(@PathVariable(value="id") long projectId, @RequestParam(value="testAutomationServerId") long testAutomationServerId) throws BindException {
        this.projectValidator.validateBindTestAutomationServerToProject(projectId, testAutomationServerId);
        this.genericProjectManager.bindTestAutomationServer(projectId, Long.valueOf(testAutomationServerId));
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestTestAutomationServerController)WebMvcLinkBuilder.methodOn(RestTestAutomationServerController.class, (Object[])new Object[0])).findTestAutomationServer(testAutomationServerId)));
        res.add(builder.withRel("test-automation-server"));
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/projects/{id}/test-automation-server"})
    public ResponseEntity<EntityModel<GenericProject>> unbindTestAutomationServerFromProject(@PathVariable(value="id") long projectId) throws BindException {
        this.projectValidator.validateUnbindTestAutomationServerFromProject(projectId);
        this.genericProjectManager.bindTestAutomationServer(projectId, null);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/projects/{projectId}/ai-servers/{aiServerId}"})
    @DynamicFilterExpression(value="*")
    public ResponseEntity bindAiServerToProject(@PathVariable(value="projectId") Long projectId, @PathVariable(value="aiServerId") Long aiServerId) {
        this.genericProjectManager.changeAiServer(projectId.longValue(), aiServerId.longValue());
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        LinkBuilder builder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestAiServerController)WebMvcLinkBuilder.methodOn(RestAiServerController.class, (Object[])new Object[0])).findAiServerById(aiServerId)));
        res.add(Link.of((String)builder.toString(), (String)"ai-server"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/projects/{id}/ai-servers"})
    public ResponseEntity<EntityModel<AiServer>> getAiServerFromProject(@NotBlank @PathVariable(value="id") Long projectId) {
        Long aiServerId = this.restProjectAdminService.getAiServerId(projectId);
        if (aiServerId != null) {
            AiServer server = this.aiServerService.findAiServerById(aiServerId);
            EntityModel<AiServer> res = this.customResource(server);
            return ResponseEntity.ok(res);
        }
        throw new EntityNotFoundException("There is no AiServer bound to project with id " + String.valueOf(projectId));
    }

    @DeleteMapping(value={"/projects/{id}/ai-servers"})
    public ResponseEntity<EntityModel<GenericProject>> unbindAiServerFromProject(@PathVariable(value="id") long projectId) {
        this.genericProjectManager.unbindAiServer(projectId);
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        EntityModel res = this.toEntityModel((Identified)project);
        return ResponseEntity.ok((Object)res);
    }

    private BugTrackerDto bugtrackerToBugtrackerDto(BugTracker bt) {
        return new BugTrackerDto(bt.getId(), bt.getName(), bt.getUrl(), bt.getKind(), bt.isIframeFriendly(), bt.getAuthenticationPolicy(), bt.getAuthenticationProtocol(), bt.getDescription(), bt.getCreatedBy(), bt.getCreatedOn(), bt.getLastModifiedBy(), bt.getLastModifiedOn());
    }

    private EntityModel<BugTrackerDto> customToResource(BugTracker bugTracker) {
        BugTrackerDto bugTrackerDto = this.bugtrackerToBugtrackerDto(bugTracker);
        return EntityModel.of((Object)bugTrackerDto);
    }

    private ResponseEntity<EntityModel<ProjectAutomationConfigurationDto>> buildAutomConfigResponseEntity(@PathVariable(value="id") long projectId, ProjectAutomationConfigurationDto automConfDto) {
        EntityModel res = EntityModel.of((Object)automConfDto);
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestProjectAdminController)((Object)WebMvcLinkBuilder.methodOn(RestProjectAdminController.class, (Object[])new Object[0]))).getProjectAutomationConfiguration(projectId))).withSelfRel());
        res.add(this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo((Object)((RestProjectController)WebMvcLinkBuilder.methodOn(RestProjectController.class, (Object[])new Object[0])).findProject(projectId))).withRel(PROJECT));
        return ResponseEntity.ok((Object)res);
    }

    private <ENTITY> EntityModel<ENTITY> customResource(ENTITY object) {
        EntityModel res = EntityModel.of(object);
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentRequestUri();
        res.add(Link.of((String)builder.toUriString(), (String)"self"));
        return res;
    }
}

